/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.handlers;

import com.google.gwt.user.client.rpc.RemoteService;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.ModuleData;
import com.googlecode.gwt.test.rpc.RemoteServiceCreateHandler;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestRemoteServiceCreateHandler
extends RemoteServiceCreateHandler {
    private static final TestRemoteServiceCreateHandler INSTANCE = new TestRemoteServiceCreateHandler();
    private final Map<String, Object> cachedServices = new HashMap<String, Object>();

    TestRemoteServiceCreateHandler() {
    }

    public static TestRemoteServiceCreateHandler get() {
        return INSTANCE;
    }

    public void reset() {
        this.cachedServices.clear();
    }

    @Override
    protected Object findService(Class<?> remoteServiceClass, String remoteServiceRelativePath) {
        Object remoteServiceInstance = this.cachedServices.get(remoteServiceRelativePath);
        if (remoteServiceInstance == null) {
            remoteServiceInstance = this.instanciateRemoteServiceInstance(remoteServiceClass, remoteServiceRelativePath);
            this.cachedServices.put(remoteServiceRelativePath, remoteServiceInstance);
        }
        return remoteServiceInstance;
    }

    private <T> T instanciateRemoteServiceInstance(Class<T> remoteServiceClass, String remoteServiceRelativePath) {
        String moduleName = GwtConfig.get().getTestedModuleName();
        Class<?> remoteServiceImplClass = ModuleData.get(moduleName).getRemoteServiceImplClass(remoteServiceRelativePath);
        if (remoteServiceImplClass == null) {
            return null;
        }
        if (!remoteServiceClass.isAssignableFrom(remoteServiceImplClass)) {
            throw new GwtTestConfigurationException("The servlet class '" + remoteServiceImplClass.getName() + "' setup for path '" + remoteServiceRelativePath + "' does not implement RemoteService interface '" + remoteServiceClass.getName());
        }
        try {
            return (T)GwtReflectionUtils.instantiateClass(remoteServiceImplClass);
        }
        catch (Exception e) {
            throw new GwtTestConfigurationException("Error during the instanciation of " + RemoteService.class.getSimpleName() + " implementation for servlet path '" + remoteServiceRelativePath + "'", e);
        }
    }
}

