/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.i18n;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.ConstantsWithLookup;
import com.google.gwt.i18n.client.DefaultDateTimeFormatInfo;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.client.impl.CldrImpl;
import com.google.gwt.i18n.client.impl.cldr.DateTimeFormatInfoImpl;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.exceptions.GwtTestI18NException;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.i18n.ConstantsInvocationHandler;
import com.googlecode.gwt.test.internal.i18n.ConstantsWithLookupInvocationHandler;
import com.googlecode.gwt.test.internal.i18n.MessagesInvocationHandler;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizableResourceCreateHandler
implements GwtCreateHandler {
    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        if (LocalizableResource.class.isAssignableFrom(classLiteral)) {
            if (!classLiteral.isInterface()) {
                throw new GwtTestI18NException(classLiteral.getSimpleName() + " must be an interface");
            }
            return LocalizableResourceProxyFactory.getFactory(classLiteral).createProxy();
        }
        if (CldrImpl.class == classLiteral) {
            return this.getLocalizedClassImpl(CldrImpl.class, CldrImpl.class);
        }
        if (DateTimeFormatInfoImpl.class == classLiteral) {
            return this.getLocalizedClassImpl(DateTimeFormatInfoImpl.class, DefaultDateTimeFormatInfo.class);
        }
        return null;
    }

    private Object getLocalizedClassImpl(Class<?> localizedClass, Class<?> defaultImpl) throws Exception {
        Class<?> implementationClass;
        Locale locale = GwtConfig.get().getModuleRunner().getLocale();
        if (locale == null) {
            return defaultImpl.newInstance();
        }
        try {
            implementationClass = GwtReflectionUtils.getClass(localizedClass.getName() + "_" + locale.getLanguage());
        }
        catch (ClassNotFoundException e) {
            try {
                implementationClass = GwtReflectionUtils.getClass(localizedClass.getName() + "_" + locale.getCountry());
            }
            catch (ClassNotFoundException e2) {
                implementationClass = null;
            }
        }
        if (implementationClass == null) {
            implementationClass = defaultImpl;
        }
        return implementationClass.newInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalizableResourceProxyFactory {
        private static Map<String, LocalizableResourceProxyFactory> factoryMap = new HashMap<String, LocalizableResourceProxyFactory>();
        private final Class<? extends LocalizableResource> proxiedClass;

        public static <T extends LocalizableResource> LocalizableResourceProxyFactory getFactory(Class<T> clazz) {
            LocalizableResourceProxyFactory factory = factoryMap.get(clazz.getName());
            if (factory == null) {
                factory = new LocalizableResourceProxyFactory(clazz);
                factoryMap.put(clazz.getName(), factory);
            }
            return factory;
        }

        private LocalizableResourceProxyFactory(Class<? extends LocalizableResource> proxiedClass) {
            this.proxiedClass = proxiedClass;
        }

        public <T extends LocalizableResource> T createProxy() {
            InvocationHandler ih = this.createInvocationHandler(this.proxiedClass);
            return (T)((LocalizableResource)Proxy.newProxyInstance(this.proxiedClass.getClassLoader(), new Class[]{this.proxiedClass}, ih));
        }

        private InvocationHandler createInvocationHandler(Class<? extends LocalizableResource> clazz) {
            if (ConstantsWithLookup.class.isAssignableFrom(clazz)) {
                return new ConstantsWithLookupInvocationHandler(clazz);
            }
            if (Constants.class.isAssignableFrom(clazz)) {
                return new ConstantsInvocationHandler(clazz);
            }
            if (Messages.class.isAssignableFrom(clazz)) {
                return new MessagesInvocationHandler(clazz);
            }
            throw new GwtTestI18NException("Not managed GWT i18n interface for testing : " + clazz.getSimpleName());
        }
    }
}

