/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.i18n;

import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.client.impl.plurals.DefaultRule;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.googlecode.gwt.test.exceptions.GwtTestI18NException;
import com.googlecode.gwt.test.internal.i18n.LocalizableResourceInvocationHandler;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessagesInvocationHandler
extends LocalizableResourceInvocationHandler {
    public MessagesInvocationHandler(Class<? extends LocalizableResource> proxiedClass) {
        super(proxiedClass);
    }

    @Override
    protected Object extractDefaultValue(Method method, Object[] args) throws Throwable {
        Messages.DefaultMessage defaultMessage = method.getAnnotation(Messages.DefaultMessage.class);
        Annotation messageAnnotation = this.getMessageAnnotation(method);
        String valuePattern = null;
        if (messageAnnotation != null) {
            String key = this.extractPluralCountAndSelectValues(messageAnnotation, method, args, this.getLocale());
            String[] values = this.getMessageAnnotationValues(messageAnnotation);
            valuePattern = this.getAnnotationValues(values).get(key);
        }
        if (valuePattern == null && defaultMessage != null) {
            valuePattern = defaultMessage.value();
        }
        if (valuePattern != null) {
            String result = this.format(valuePattern, args, this.getLocale());
            return method.getReturnType() == SafeHtml.class ? SafeHtmlUtils.fromTrustedString((String)result) : result;
        }
        return null;
    }

    @Override
    protected Object extractFromProperties(Properties localizedProperties, Method method, Object[] args, Locale locale) throws Throwable {
        Annotation messageAnnotation = this.getMessageAnnotation(method);
        String key = messageAnnotation == null ? this.getKey(method) : this.getSpecificKey(messageAnnotation, method, args, locale);
        String result = this.extractProperty(localizedProperties, key);
        if (result != null) {
            result = this.format(result, args, locale);
            return method.getReturnType() == SafeHtml.class ? SafeHtmlUtils.fromTrustedString((String)result) : result;
        }
        return null;
    }

    protected String extractProperty(Properties properties, String key) {
        String result = properties.getProperty(key);
        if (result == null) {
            result = properties.getProperty(key.replaceAll("_", "."));
        }
        return result;
    }

    private String extractPluralCountAndSelectValues(Annotation messageAnnotation, Method method, Object[] args, Locale locale) {
        Annotation[][] annotations = method.getParameterAnnotations();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] childArray = annotations[i];
            for (int j = 0; j < childArray.length; ++j) {
                if (Messages.PluralCount.class.isAssignableFrom(childArray[j].getClass())) {
                    Messages.PluralCount pluralCount = (Messages.PluralCount)childArray[j];
                    Class pluralRuleClass = pluralCount.value();
                    int count = (Integer)args[i];
                    String pluralRuleClassName = pluralRuleClass != PluralRule.class ? pluralRuleClass.getName() : DefaultRule.class.getName();
                    pluralRuleClassName = pluralRuleClassName + "_" + locale.getLanguage();
                    try {
                        Class<?> acutalRule = GwtReflectionUtils.getClass(pluralRuleClassName);
                        PluralRule ruleInstance = (PluralRule)acutalRule.newInstance();
                        sb.append(ruleInstance.pluralForms()[ruleInstance.select(count)].getName()).append("|");
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new GwtTestI18NException("Cannot find PluralRule for method '" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()'. Expected PluralRule : '" + pluralRuleClassName + "'");
                    }
                    catch (InstantiationException e) {
                        throw new GwtTestI18NException("Error during instanciation of class '" + pluralRuleClassName + "'", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new GwtTestI18NException("Error during instanciation of class '" + pluralRuleClassName + "'", e);
                    }
                }
                if (!Messages.Select.class.isAssignableFrom(childArray[j].getClass())) continue;
                sb.append(args[i]).append("|");
            }
        }
        if (sb.length() == 0) {
            throw new GwtTestI18NException("Bad configuration of '" + method.getDeclaringClass() + "." + method.getName() + "' : a @" + messageAnnotation.getClass().getSimpleName() + " is declared but no @" + Messages.PluralCount.class.getSimpleName() + " or @" + Messages.Select.class.getSimpleName() + " set on any method parameter'");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private String format(String pattern, Object[] args, Locale locale) {
        MessageFormat format = locale == null ? new MessageFormat(pattern) : new MessageFormat(pattern, locale);
        return format.format(args);
    }

    private Map<String, String> getAnnotationValues(String[] annotationValues) {
        HashMap<String, String> pluralForms = new HashMap<String, String>();
        for (int i = 0; i < annotationValues.length; ++i) {
            pluralForms.put(annotationValues[i], annotationValues[++i]);
        }
        return pluralForms;
    }

    private Annotation getMessageAnnotation(Method method) {
        Messages.AlternateMessage specificMessageAnnotation = method.getAnnotation(Messages.AlternateMessage.class);
        if (specificMessageAnnotation == null) {
            specificMessageAnnotation = method.getAnnotation(Messages.PluralText.class);
        }
        return specificMessageAnnotation;
    }

    private String[] getMessageAnnotationValues(Annotation messageAnnotation) {
        if (Messages.AlternateMessage.class.isInstance(messageAnnotation)) {
            return ((Messages.AlternateMessage)messageAnnotation).value();
        }
        if (Messages.PluralText.class.isInstance(messageAnnotation)) {
            return ((Messages.PluralText)messageAnnotation).value();
        }
        return null;
    }

    private String getSpecificKey(Annotation specificMessageAnnotation, Method method, Object[] args, Locale locale) {
        String pluralCountValue = this.extractPluralCountAndSelectValues(specificMessageAnnotation, method, args, locale);
        return method.getName() + "[" + pluralCountValue + "]";
    }
}

