/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PatchClass(target="com.google.gwt.storage.client.StorageImpl")
class StorageImplPatcher {
    static final String LOCAL_STORAGE = "localStorage";
    static final String SESSION_STORAGE = "sessionStorage";

    StorageImplPatcher() {
    }

    @PatchMethod
    static void clear(Object storageImpl, String storage) {
        StorageImplPatcher.getStorage(storage).clear();
    }

    @PatchMethod
    static String getItem(Object storageImpl, String storage, String key) {
        return StorageImplPatcher.getStorage(storage).get(key);
    }

    @PatchMethod
    static int getLength(Object storageImpl, String storage) {
        return StorageImplPatcher.getStorage(storage).size();
    }

    @PatchMethod
    static String key(Object storageImpl, String storage, int index) {
        Set<String> keys = StorageImplPatcher.getStorage(storage).keySet();
        if (index < 0 || index >= keys.size()) {
            return null;
        }
        Iterator<String> it = keys.iterator();
        int i = 0;
        while (i++ < index) {
            it.next();
        }
        return it.next();
    }

    @PatchMethod
    static void removeItem(Object storageImpl, String storage, String key) {
        StorageImplPatcher.getStorage(storage).remove(key);
    }

    @PatchMethod
    static void setItem(Object storageImpl, String storage, String key, String data) {
        StorageImplPatcher.getStorage(storage).put(key, data);
    }

    private static Map<String, String> getStorage(String storage) {
        if (LOCAL_STORAGE.equals(storage)) {
            return StorageHolder.get().localStorage;
        }
        return StorageHolder.get().sessionStorage;
    }

    private static class StorageHolder
    implements AfterTestCallback {
        private static StorageHolder instance;
        private final Map<String, String> localStorage = new LinkedHashMap<String, String>();
        private final Map<String, String> sessionStorage = new LinkedHashMap<String, String>();

        private static StorageHolder get() {
            if (instance == null) {
                instance = new StorageHolder();
            }
            return instance;
        }

        StorageHolder() {
            AfterTestCallbackManager.get().registerCallback(this);
        }

        public void afterTest() throws Throwable {
            this.localStorage.clear();
            this.sessionStorage.clear();
        }
    }
}

