/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.ext.DefaultExtensions;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.ImageBundle;
import com.google.gwt.user.client.ui.impl.ClippedImagePrototype;
import com.googlecode.gwt.test.GwtCreateHandler;
import com.googlecode.gwt.test.exceptions.GwtTestResourcesException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageBundleCreateHandler
implements GwtCreateHandler {
    private static final String[] IMAGE_DEFAULT_EXTENSIONS = ImageResource.class.getAnnotation(DefaultExtensions.class).value();

    @Override
    public Object create(Class<?> classLiteral) throws Exception {
        if (!ImageBundle.class.isAssignableFrom(classLiteral)) {
            return null;
        }
        return this.generateImageWrapper(classLiteral);
    }

    private Object generateImageWrapper(Class<?> clazz) {
        InvocationHandler ih = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getReturnType() == AbstractImagePrototype.class) {
                    String url = this.getImageUrl(method);
                    return new ClippedImagePrototype(url, 0, 0, 0, 0);
                }
                throw new GwtTestResourcesException("Not managed return type for image bundle : " + method.getReturnType().getSimpleName());
            }

            private String computeFileSimpleName(Method method) {
                String packagePath = method.getDeclaringClass().getPackage().getName().replaceAll("\\.", "/");
                String relativePath = packagePath + "/" + method.getName();
                for (String extension : IMAGE_DEFAULT_EXTENSIONS) {
                    String possiblePath = relativePath + extension;
                    if (this.getClass().getResource("/" + possiblePath) == null) continue;
                    return method.getName() + extension;
                }
                throw new GwtTestResourcesException("Cannot find an image with path relative to '" + relativePath + "'");
            }

            private String getImageUrl(Method method) {
                ImageBundle.Resource resource = method.getAnnotation(ImageBundle.Resource.class);
                String fileName = resource != null ? resource.value() : this.computeFileSimpleName(method);
                return GWT.getModuleBaseURL() + fileName;
            }
        };
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, ih);
    }
}

