/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.resources;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.TextResource;
import com.googlecode.gwt.test.exceptions.GwtTestResourcesException;
import com.googlecode.gwt.test.internal.resources.CssResourceCallback;
import com.googlecode.gwt.test.internal.resources.DataResourceCallback;
import com.googlecode.gwt.test.internal.resources.ImageResourceCallback;
import com.googlecode.gwt.test.internal.resources.ResourcePrototypeCallback;
import com.googlecode.gwt.test.internal.resources.TextResourceCallback;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePrototypeProxyBuilder {
    private String name;
    private final Class<?> ownerClass;
    private final Class<?> proxiedClass;
    private String text;
    private List<URL> urls;

    public static ResourcePrototypeProxyBuilder createBuilder(Class<?> proxiedClass, Class<?> ownerClass) {
        return new ResourcePrototypeProxyBuilder(proxiedClass, ownerClass);
    }

    private ResourcePrototypeProxyBuilder(Class<?> proxiedClass, Class<?> ownerClass) {
        if (!proxiedClass.isInterface()) {
            throw new GwtTestResourcesException("Cannot create a resource proxy instance for '" + proxiedClass.getName() + "' because it is not an interface");
        }
        this.proxiedClass = proxiedClass;
        this.ownerClass = ownerClass;
    }

    public Object build() {
        ResourcePrototypeCallback callback;
        if (TextResource.class.isAssignableFrom(this.proxiedClass)) {
            callback = this.urls != null ? new TextResourceCallback(this.urls) : new TextResourceCallback(this.text);
        } else if (CssResource.class.isAssignableFrom(this.proxiedClass)) {
            callback = this.urls != null ? new CssResourceCallback(this.urls) : new CssResourceCallback(this.text);
        } else if (DataResource.class.isAssignableFrom(this.proxiedClass)) {
            callback = new DataResourceCallback(this.computeUrl(this.urls, this.ownerClass));
        } else if (ImageResource.class.isAssignableFrom(this.proxiedClass)) {
            callback = new ImageResourceCallback(this.computeImageUrl(this.urls, this.ownerClass));
        } else {
            throw new GwtTestResourcesException("Not managed return type for ClientBundle : " + this.proxiedClass.getName());
        }
        InvocationHandler resourceInvocationHandler = this.generateInvocationHandler(callback);
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.proxiedClass}, resourceInvocationHandler);
    }

    public ResourcePrototypeProxyBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ResourcePrototypeProxyBuilder resourceURL(URL url) {
        this.urls = new ArrayList<URL>(1);
        this.urls.add(url);
        return this;
    }

    public ResourcePrototypeProxyBuilder resourceURLs(List<URL> url) {
        this.urls = url;
        return this;
    }

    public ResourcePrototypeProxyBuilder text(String text) {
        this.text = text;
        return this;
    }

    private String computeImageUrl(List<URL> resourceURLs, Class<?> resourceClass) {
        if (resourceURLs.size() > 1) {
            throw new GwtTestResourcesException("Too many ImageResource files found for method '" + this.ownerClass.getName() + "." + this.name + "()'");
        }
        return this.computeUrl(resourceURLs, resourceClass);
    }

    private String computeUrl(List<URL> resourceURLs, Class<?> resourceClass) {
        StringBuilder sb = new StringBuilder();
        for (URL url : resourceURLs) {
            sb.append(this.extractFileName(url, resourceClass)).append("_");
        }
        return GWT.getModuleBaseURL() + sb.substring(0, sb.length() - 1);
    }

    private String extractFileName(URL resourceURL, Class<?> resourceClass) {
        return resourceURL.getPath().substring(resourceURL.getPath().lastIndexOf(47) + 1);
    }

    private InvocationHandler generateInvocationHandler(ResourcePrototypeCallback callback) {
        ResourcePrototypeInvocationHandler ih = new ResourcePrototypeInvocationHandler();
        ih.callback = callback;
        ih.name = this.name;
        ih.ownerClass = this.ownerClass;
        ih.proxiedClass = this.proxiedClass;
        return ih;
    }

    private static class ResourcePrototypeInvocationHandler
    implements InvocationHandler {
        private ResourcePrototypeCallback callback;
        private String name;
        private Class<?> ownerClass;
        private Class<?> proxiedClass;

        private ResourcePrototypeInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getName".equals(method.getName())) {
                return this.name;
            }
            if ("toString".equals(method.getName())) {
                return this.callback.getClass().getName() + " generated for '" + this.ownerClass.getName() + "." + this.name + "()'";
            }
            if ("hashCode".equals(method.getName())) {
                return this.callback.hashCode();
            }
            if ("equals".equals(method.getName())) {
                return this.areEqual(this.callback, args[0]);
            }
            Object result = this.callback.call(method, args);
            if (result != null) {
                return result;
            }
            throw new GwtTestResourcesException("Not managed method '" + method.getName() + "' for generated '" + this.proxiedClass.getName() + "' proxy");
        }

        private boolean areEqual(ResourcePrototypeCallback myCallback, Object object) {
            if (!Proxy.isProxyClass(object.getClass())) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(object);
            if (ResourcePrototypeInvocationHandler.class != ih.getClass()) {
                return false;
            }
            ResourcePrototypeCallback itsCallback = ((ResourcePrototypeInvocationHandler)ih).callback;
            return myCallback.equals(itsCallback);
        }
    }
}

