/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.utils;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.internal.utils.GwtHtmlContentHandler;
import com.googlecode.gwt.test.internal.utils.JsoUtils;
import com.googlecode.html.filters.DefaultFilter;
import java.io.StringReader;
import java.util.Collections;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtHtmlParser
implements AfterTestCallback {
    private static GwtHtmlParser INSTANCE = new GwtHtmlParser();
    private XMLReader reader;

    public static NodeList<Node> parse(String html) {
        return INSTANCE.parseInternal(html);
    }

    private GwtHtmlParser() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() throws Throwable {
        this.reader = null;
    }

    private XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = XMLReaderFactory.createXMLReader("com.googlecode.html.parsers.SAXParser");
            this.reader.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            this.reader.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            this.reader.setProperty("http://cyberneko.org/html/properties/default-encoding", "UTF-8");
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{new NbspRemover()};
            this.reader.setProperty("http://cyberneko.org/html/properties/filters", filters);
        }
        return this.reader;
    }

    private NodeList<Node> parseInternal(String html) {
        if (html == null || html.trim().length() == 0) {
            return JsoUtils.newNodeList(Collections.emptyList());
        }
        try {
            XMLReader xmlReader = this.getXMLReader();
            GwtHtmlContentHandler contentHandler = new GwtHtmlContentHandler();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new StringReader(html)));
            return contentHandler.getParsedNodes();
        }
        catch (Exception e) {
            throw new GwtTestPatchException("Error while parsing HTML '" + html + "'", e);
        }
    }

    private static class NbspRemover
    extends DefaultFilter {
        private static final String NBSP_ENTITY_NAME = "nbsp";
        boolean inNbspEntityRef;
        XMLString nbspXMLString = new XMLString();

        private NbspRemover() {
            char[] c = new char[]{'&', 'n', 'b', 's', 'p', ';'};
            this.nbspXMLString.setValues(c, 0, 6);
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (!this.inNbspEntityRef) {
                super.characters(text, augs);
            }
        }

        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
            this.inNbspEntityRef = false;
        }

        public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
            super.startDocument(locator, encoding, augs);
            this.inNbspEntityRef = false;
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
            if (NBSP_ENTITY_NAME.equals(name)) {
                this.inNbspEntityRef = true;
                super.characters(this.nbspXMLString, augs);
            } else {
                super.startGeneralEntity(name, id, encoding, augs);
            }
        }
    }
}

