/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.utils;

import com.google.gwt.core.client.GWT;
import com.googlecode.gwt.test.exceptions.GwtTestConfigurationException;
import com.googlecode.gwt.test.exceptions.GwtTestException;
import com.googlecode.gwt.test.internal.utils.XmlUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXmlUtils {
    private static WebXmlUtils INSTANCE;
    private static final String[] WAR_ROOTS;
    private static final String WEB_XML = "WEB-INF/web.xml";
    private final Set<String> listenerClasses;
    private final Map<String, String> servletClassMap;

    public static WebXmlUtils get() {
        if (INSTANCE == null) {
            INSTANCE = new WebXmlUtils();
        }
        return INSTANCE;
    }

    private WebXmlUtils() {
        InputStream is = this.getWebXmlAsStream();
        try {
            DocumentBuilder builder = XmlUtils.newDocumentBuilder();
            Document document = builder.parse(is);
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.servletClassMap = this.parseServletClassMap(document, xpath);
            this.listenerClasses = this.parseListeners(document, xpath);
        }
        catch (Exception e) {
            if (GwtTestException.class.isInstance(e)) {
                throw (GwtTestException)e;
            }
            throw new GwtTestConfigurationException("Error while parsing web.xml", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ioException) {}
        }
    }

    public Set<String> getListenerClasses() {
        return this.listenerClasses;
    }

    public String getServletClass(String servletPath) {
        return this.servletClassMap.get(servletPath);
    }

    private InputStream getWebXmlAsStream() {
        for (String warRoot : WAR_ROOTS) {
            try {
                return new FileInputStream(warRoot + WEB_XML);
            }
            catch (FileNotFoundException e) {
            }
        }
        throw new GwtTestConfigurationException("Cannot find 'web.xml' file ' for GWT module " + GWT.getModuleName());
    }

    private Set<String> parseListeners(Document document, XPath xpath) throws XPathExpressionException {
        HashSet<String> result = new HashSet<String>();
        NodeList listeners = (NodeList)xpath.evaluate("/web-app/listener", document, XPathConstants.NODESET);
        for (int i = 0; i < listeners.getLength(); ++i) {
            Node listenerCandidate = listeners.item(i);
            String listenerClassName = xpath.evaluate("listener-class", listenerCandidate);
            result.add(listenerClassName);
        }
        return result;
    }

    private Map<String, String> parseMappingElements(Document document, XPath xpath) throws XPathExpressionException {
        NodeList mappings = (NodeList)xpath.evaluate("/web-app/servlet-mapping", document, XPathConstants.NODESET);
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        for (int i = 0; i < mappings.getLength(); ++i) {
            Node mapping = mappings.item(i);
            String servletName = xpath.evaluate("servlet-name", mapping);
            String urlPattern = xpath.evaluate("url-pattern", mapping);
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            mappingsMap.put(servletName, urlPattern);
        }
        return mappingsMap;
    }

    private Map<String, String> parseServletClassMap(Document document, XPath xpath) throws XPathExpressionException {
        Map<String, String> servletsMap = this.parseServletElements(document, xpath);
        Map<String, String> mappingsMap = this.parseMappingElements(document, xpath);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> mappingsEntry : mappingsMap.entrySet()) {
            result.put(mappingsEntry.getValue(), servletsMap.get(mappingsEntry.getKey()));
        }
        return result;
    }

    private Map<String, String> parseServletElements(Document document, XPath xpath) throws XPathExpressionException {
        NodeList servlets = (NodeList)xpath.evaluate("/web-app/servlet", document, XPathConstants.NODESET);
        HashMap<String, String> servletsMap = new HashMap<String, String>();
        for (int i = 0; i < servlets.getLength(); ++i) {
            Node servlet = servlets.item(i);
            String servletName = xpath.evaluate("servlet-name", servlet);
            String servletClass = xpath.evaluate("servlet-class", servlet);
            servletsMap.put(servletName, servletClass);
        }
        return servletsMap;
    }

    static {
        WAR_ROOTS = new String[]{"war/", "src/main/webapp/"};
    }
}

