/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder.widget;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.IsWidget;
import com.googlecode.gwt.test.uibinder.UiBinderXmlUtils;
import com.googlecode.gwt.test.uibinder.UiObjectTag;
import com.googlecode.gwt.test.uibinder.UiObjectTagFactory;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiGridTagFactory
implements UiObjectTagFactory<Grid> {
    private static final String CELL_TAG = "cell";
    private static final String CUSTOMCELL_TAG = "customCell";
    private static final String ROW_TAG = "row";
    private static final String STYLE_ATTR = "styleName";

    @Override
    public UiObjectTag<Grid> createUiObjectTag(Class<?> clazz, Map<String, Object> attributes) {
        if (!Grid.class.isAssignableFrom(clazz)) {
            return null;
        }
        return new GridTag();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GridTag
    extends UiObjectTag<Grid> {
        private int currentRowIndex = 0;
        private int numColumns;

        private GridTag() {
        }

        @Override
        protected void appendElement(Grid wrapped, Element element, String namespaceURI, List<IsWidget> childWidgets) {
            if (!UiGridTagFactory.ROW_TAG.equals(element.getTagName()) || !"urn:import:com.google.gwt.user.client.ui".equals(namespaceURI)) {
                super.appendElement(wrapped, element, namespaceURI, childWidgets);
            } else {
                this.handleRow(wrapped, element);
                ++this.currentRowIndex;
            }
        }

        @Override
        protected void finalizeObject(Grid uiObject) {
        }

        @Override
        protected void initializeObject(Grid wrapped, Map<String, Object> attributes, Object owner) {
        }

        private void checkGridSize(Grid wrapped, int columnIndex) {
            if (this.numColumns <= columnIndex) {
                this.numColumns = columnIndex + 1;
                wrapped.resize(this.currentRowIndex + 1, this.numColumns);
            }
        }

        private void handleCell(Grid wrapped, Element element, int columnIndex) {
            this.checkGridSize(wrapped, columnIndex);
            wrapped.setHTML(this.currentRowIndex, columnIndex, element.getInnerHTML());
            this.handleCellStyle(wrapped, element, columnIndex);
        }

        private void handleCellStyle(Grid wrapped, Element element, int columnIndex) {
            String styleName = element.getAttribute(UiGridTagFactory.STYLE_ATTR);
            if (styleName.length() > 0) {
                wrapped.getCellFormatter().setStyleName(this.currentRowIndex, columnIndex, styleName);
            }
        }

        private void handleCustomCell(Grid wrapped, Element element, List<IsWidget> childWidgets, int columnIndex) {
            this.checkGridSize(wrapped, columnIndex);
            IsWidget w = childWidgets.size() > 0 ? childWidgets.get(0) : null;
            wrapped.setWidget(this.currentRowIndex, columnIndex, w);
            this.handleCellStyle(wrapped, element, columnIndex);
        }

        private void handleRow(Grid wrapped, Element element) {
            wrapped.insertRow(this.currentRowIndex);
            String styleName = element.getAttribute(UiGridTagFactory.STYLE_ATTR);
            if (styleName.length() > 0) {
                wrapped.getRowFormatter().setStyleName(this.currentRowIndex, styleName);
            }
            this.handleRowCells(wrapped, element);
        }

        private void handleRowCells(Grid wrapped, Element element) {
            int columnIndex = 0;
            NodeList childs = element.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Element e = (Element)childs.getItem(i).cast();
                if (UiGridTagFactory.CELL_TAG.equals(e.getTagName())) {
                    this.handleCell(wrapped, e, columnIndex++);
                    continue;
                }
                if (!UiGridTagFactory.CUSTOMCELL_TAG.equals(e.getTagName())) continue;
                this.handleCustomCell(wrapped, e, UiBinderXmlUtils.getChildWidgets(e), columnIndex++);
            }
        }
    }
}

