/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.utils;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.StringMemberValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistUtils {
    public static CtConstructor findConstructor(CtClass ctClass, Class<?> ... argsClasses) {
        HashSet<CtConstructor> set = new HashSet<CtConstructor>();
        JavassistUtils.findConstructors(ctClass, set, argsClasses);
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CtConstructor)set.iterator().next();
            }
        }
        throw new GwtTestPatchException("Multiple constructors (" + set.size() + ") in class " + ctClass.getName() + ", you have to set parameter types discriminators");
    }

    public static <T extends java.lang.annotation.Annotation> Annotation getAnnotation(CtClass ctClass, Class<T> annotationClass) throws ClassNotFoundException {
        java.lang.annotation.Annotation proxiedAnnot = (java.lang.annotation.Annotation)ctClass.getAnnotation(annotationClass);
        if (proxiedAnnot == null) {
            return null;
        }
        if (!Proxy.isProxyClass(proxiedAnnot.getClass())) {
            return null;
        }
        AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(proxiedAnnot);
        return impl.getAnnotation();
    }

    public static String getInvisibleAnnotationStringValue(Class<?> clazz, Class<? extends java.lang.annotation.Annotation> annotation, String name) {
        CtClass ctClass = GwtClassPool.getCtClass(clazz);
        ctClass.defrost();
        AnnotationsAttribute attr = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        if (attr == null) {
            attr = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeInvisibleAnnotations");
        }
        if (attr == null) {
            return null;
        }
        Annotation an = attr.getAnnotation(annotation.getName());
        ctClass.freeze();
        return an != null ? ((StringMemberValue)an.getMemberValue(name)).getValue() : null;
    }

    public static String getInvisibleAnnotationStringValue(Method method, Class<? extends java.lang.annotation.Annotation> annotation, String name) {
        CtClass ctClass = GwtClassPool.getCtClass(method.getDeclaringClass());
        ctClass.defrost();
        AnnotationsAttribute attr = (AnnotationsAttribute)ctClass.getClassFile().getMethod(method.getName()).getAttribute("RuntimeVisibleAnnotations");
        if (attr == null) {
            attr = (AnnotationsAttribute)ctClass.getClassFile().getMethod(method.getName()).getAttribute("RuntimeInvisibleAnnotations");
        }
        if (attr == null) {
            return null;
        }
        Annotation an = attr.getAnnotation(annotation.getName());
        ctClass.freeze();
        return an != null ? ((StringMemberValue)an.getMemberValue(name)).getValue() : null;
    }

    private static void findConstructors(CtClass ctClass, Set<CtConstructor> set, Class<?> ... argsClasses) {
        try {
            if (ctClass == null) {
                return;
            }
            CtConstructor[] constructors = ctClass.getDeclaredConstructors();
            if (constructors.length == 0) {
                JavassistUtils.findConstructors(ctClass.getSuperclass(), set, argsClasses);
            } else if (constructors.length == 1 && argsClasses.length == 0) {
                set.add(constructors[0]);
            } else {
                for (CtConstructor c : constructors) {
                    if (c.getParameterTypes().length != argsClasses.length) continue;
                    boolean sameArgs = true;
                    for (int i = 0; i < argsClasses.length; ++i) {
                        String currentClassName;
                        String requestedClassName = argsClasses[i].getName();
                        if (requestedClassName.equals(currentClassName = c.getParameterTypes()[i].getName())) continue;
                        sameArgs = false;
                    }
                    if (!sameArgs) continue;
                    set.add(c);
                }
            }
        }
        catch (NotFoundException e) {
            throw new GwtTestPatchException("Error while trying find a constructor in class '" + ctClass.getName() + "'", e);
        }
    }

    private JavassistUtils() {
    }
}

