/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.StringAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HeaderValueHolder {
    private final List<Object> values = new LinkedList<Object>();

    HeaderValueHolder() {
    }

    public static HeaderValueHolder getByName(Map<String, HeaderValueHolder> headers, String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Header name must not be null")).isNotNull();
        for (String headerName : headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headers.get(headerName);
        }
        return null;
    }

    private static void mergeArrayIntoCollection(Object array, Collection<Object> collection) {
        Object[] arr;
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        for (Object elem : arr = HeaderValueHolder.toObjectArray(array)) {
            collection.add(elem);
        }
    }

    private static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return new Object[0];
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source);
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void addValueArray(Object values) {
        HeaderValueHolder.mergeArrayIntoCollection(values, this.values);
    }

    public void addValues(Collection<?> values) {
        this.values.addAll(values);
    }

    public List<String> getStringValues() {
        ArrayList<String> stringList = new ArrayList<String>(this.values.size());
        for (Object value : this.values) {
            stringList.add(value.toString());
        }
        return Collections.unmodifiableList(stringList);
    }

    public Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    public List<Object> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void setValue(Object value) {
        this.values.clear();
        this.values.add(value);
    }
}

