/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import java.util.Iterator;

public class IteratorTool {
    public static <T> Iterable<T> wrap(Iterator<T> it) {
        return new Wrapped<T>(it);
    }

    public static class Wrapped<T>
    implements Iterable<T> {
        private final Iterator<T> it;
        private boolean exhausted = false;

        public Wrapped(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.exhausted) {
                throw new IllegalStateException("Can be called only once, sorry");
            }
            this.exhausted = true;
            return this.it;
        }
    }
}

