/*
 * Decompiled with CFR 0.152.
 */
package de.xam.velocity;

import org.apache.velocity.VelocityContext;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class MeasuringVelocityContext
extends VelocityContext {
    private static final Logger log = LoggerFactory.getLogger(MeasuringVelocityContext.class);
    long spent = 0L;
    private final VelocityContext ctx;

    public Object internalGet(String key) {
        long start = System.nanoTime();
        Object o = this.ctx.internalGet(key);
        long delta = System.nanoTime() - start;
        MeasuringVelocityContext.maybeWarn(delta);
        this.spent += delta;
        log.debug("key '" + key + "', spent " + delta + ", total: " + this.spent);
        return o;
    }

    public Object internalPut(String key, Object value) {
        long start = System.nanoTime();
        Object o = this.ctx.internalPut(key, value);
        long delta = System.nanoTime() - start;
        MeasuringVelocityContext.maybeWarn(delta);
        this.spent += delta;
        log.debug("key '" + key + "', spent " + delta + ", total: " + this.spent);
        return o;
    }

    public boolean internalContainsKey(Object key) {
        long start = System.nanoTime();
        boolean o = this.ctx.internalContainsKey(key);
        long delta = System.nanoTime() - start;
        MeasuringVelocityContext.maybeWarn(delta);
        this.spent += delta;
        log.debug("key '" + key + "', spent " + delta + ", total: " + this.spent);
        return o;
    }

    public Object[] internalGetKeys() {
        long start = System.nanoTime();
        Object[] o = this.ctx.internalGetKeys();
        long delta = System.nanoTime() - start;
        MeasuringVelocityContext.maybeWarn(delta);
        this.spent += delta;
        log.debug("Spent " + delta + ", total: " + this.spent);
        return o;
    }

    public Object internalRemove(Object key) {
        long start = System.nanoTime();
        Object o = this.ctx.internalRemove(key);
        long delta = System.nanoTime() - start;
        MeasuringVelocityContext.maybeWarn(delta);
        this.spent += delta;
        log.debug("key '" + key + "', spent " + delta + ", total: " + this.spent);
        return o;
    }

    private static void maybeWarn(long delta) {
        if (delta > 5000000L) {
            log.warn("Took longer than 5 ms");
        }
    }

    public MeasuringVelocityContext(VelocityContext ctx) {
        this.ctx = ctx;
    }
}

