/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui;

import de.xam.dwz1.webgui.Router;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.core.util.RegExUtil;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class PartialEditLinks {
    private static final Logger log = LoggerFactory.getLogger(PartialEditLinks.class);
    static final Pattern p_HTML_HEADLINE = Pattern.compile("<([hH][1-6])([^>]*)>([^<]+)</[hH][1-6]>");

    public static String addPartialEditLinks(XId itemId, String wikiSource, String wikiHtml) {
        assert (wikiHtml != null);
        ArrayList<SourcePart> list = new ArrayList<SourcePart>();
        Matcher m_html = p_HTML_HEADLINE.matcher(wikiHtml);
        while (m_html.find()) {
            int startWikiHtml = m_html.start();
            int endWikiHtml = m_html.end();
            String tagName = m_html.group(1);
            String att = m_html.group(2);
            String content = m_html.group(3);
            String source_headlineContent = "[!]+ *" + RegExUtil.regexEncode((String)content);
            Pattern p_headlineContent = Pattern.compile(source_headlineContent);
            Matcher m_wikiSource = p_headlineContent.matcher(wikiSource);
            if (m_wikiSource.find()) {
                int startWikiSource = m_wikiSource.start();
                if (m_wikiSource.find(m_wikiSource.end())) {
                    log.info("String '" + content + "' found multiple times in wiki source, not usable as anchor");
                    continue;
                }
                SourcePart sourcePart = new SourcePart(att, startWikiSource, tagName, startWikiHtml, endWikiHtml, content);
                list.add(sourcePart);
                continue;
            }
            log.warn("String '" + content + "' found in headline in html, but not in source");
        }
        if (list.size() == 0) {
            return wikiHtml;
        }
        StringBuilder b = new StringBuilder();
        int lastHtmlEnd = 0;
        for (int i = 0; i < list.size(); ++i) {
            SourcePart part = (SourcePart)list.get(i);
            int startHtml = part.startWikiHtml;
            if (startHtml > 0) {
                String copy = wikiHtml.substring(lastHtmlEnd, startHtml);
                b.append(copy);
            }
            String tagName = part.tagName;
            String att = part.attributes;
            String content = part.tagContent;
            int startSource = part.startWikiSource;
            int endSource = i + 1 < list.size() ? ((SourcePart)list.get((int)(i + 1))).startWikiSource : wikiSource.length();
            b.append("<");
            b.append(tagName);
            b.append(att);
            b.append(" data-start='");
            b.append(startSource);
            b.append("'");
            b.append(" data-end='");
            b.append(endSource);
            b.append("'");
            b.append(">");
            b.append(content);
            b.append("<a class='editpart' href='");
            b.append(Router.get().url_item_edit("" + itemId, "" + startSource, "" + endSource));
            b.append("'>");
            b.append("&nbsp;");
            b.append("</a>");
            b.append("</");
            b.append(tagName);
            b.append(">");
            lastHtmlEnd = part.endWikiHtml;
        }
        if (lastHtmlEnd < wikiHtml.length()) {
            String copy = wikiHtml.substring(lastHtmlEnd);
            b.append(copy);
        }
        return b.toString();
    }

    public static void main(String[] args) {
        String source = "Baz\n!! Hello\nFooo Bar\n!!AAA\nhuhu";
        String html = "Baz<h2 class='foo'>Hello</h2>Fooo Bar<h2 class='aaa'>AAA</h2>";
        XId itemId = Base.toId((String)"HelloWorld");
        System.out.println(PartialEditLinks.addPartialEditLinks(itemId, "Baz\n!! Hello\nFooo Bar\n!!AAA\nhuhu", "Baz<h2 class='foo'>Hello</h2>Fooo Bar<h2 class='aaa'>AAA</h2>"));
    }

    private static class SourcePart {
        String attributes;
        int endWikiHtml;
        int startWikiHtml;
        int startWikiSource;
        String tagContent;
        String tagName;

        public SourcePart(String attributes, int startWikiSource, String tagName, int startWikiHtml, int endWikiHtml, String tagContent) {
            this.attributes = attributes;
            this.startWikiSource = startWikiSource;
            this.tagName = tagName;
            this.startWikiHtml = startWikiHtml;
            this.endWikiHtml = endWikiHtml;
            this.tagContent = tagContent;
        }
    }
}

