/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui;

import de.xam.texthtml.text.TextTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;

public class RouterBuilder {
    private static final String POST_AND_GET = "POST_AND_GET";
    private final Restless restless;
    private final List<Section> sections = new ArrayList<Section>();
    private final List<Method> methods = new ArrayList<Method>();
    private boolean isDone = false;

    public RouterBuilder(Restless restless) {
        this.restless = restless;
    }

    public Section section(Class<?> mappedClass) {
        Section section = new Section(mappedClass);
        this.sections.add(section);
        return section;
    }

    public RouterBuilder done() {
        if (this.isDone) {
            throw new IllegalStateException();
        }
        this.isDone = true;
        for (Method method : this.methods) {
            ArrayList<? extends RestlessParameter> restlessParameters = new ArrayList<RestlessParameter>();
            restlessParameters.addAll(method.toRestlessParameters());
            Object mappedInstanceOrClass = method.section.mappedInstanceOrClass;
            if (method.httpMethod.equals(POST_AND_GET)) {
                this.restless.addMethod(method.absoluteUrlPathTemplate, "POST", mappedInstanceOrClass, method.javaMethodName, method.isAdminOnly, restlessParameters.toArray(new RestlessParameter[restlessParameters.size()]));
                this.restless.addMethod(method.absoluteUrlPathTemplate, "GET", mappedInstanceOrClass, method.javaMethodName, method.isAdminOnly, restlessParameters.toArray(new RestlessParameter[restlessParameters.size()]));
                continue;
            }
            this.restless.addMethod(method.absoluteUrlPathTemplate, method.httpMethod, mappedInstanceOrClass, method.javaMethodName, method.isAdminOnly, restlessParameters.toArray(new RestlessParameter[restlessParameters.size()]));
        }
        return this;
    }

    class Section {
        private final Object mappedInstanceOrClass;

        public Section(Object mappedInstanceOrClass) {
            this.mappedInstanceOrClass = mappedInstanceOrClass;
        }

        public Method GET(String absoluteUrlPathTemplate) {
            Method method = new Method(this, "GET");
            method.absoluteUrlPathTemplate = TextTool.urlDecode((String)absoluteUrlPathTemplate);
            RouterBuilder.this.methods.add(method);
            return method;
        }

        public Method POST(String absoluteUrlPathTemplate) {
            Method method = new Method(this, "POST");
            method.absoluteUrlPathTemplate = TextTool.urlDecode((String)absoluteUrlPathTemplate);
            RouterBuilder.this.methods.add(method);
            return method;
        }

        public Method POST_AND_GET(String absoluteUrlPathTemplate) {
            Method method = new Method(this, RouterBuilder.POST_AND_GET);
            method.absoluteUrlPathTemplate = TextTool.urlDecode((String)absoluteUrlPathTemplate);
            RouterBuilder.this.methods.add(method);
            return method;
        }

        public RouterBuilder done() {
            return RouterBuilder.this.done();
        }
    }

    class Method {
        String httpMethod;
        String absoluteUrlPathTemplate;
        String javaMethodName;
        List<Parameter> parameters = new ArrayList<Parameter>();
        transient Set<String> parameterNames = new HashSet<String>();
        boolean isAdminOnly = false;
        private final Section section;

        private Method(Section section, String httpMethod) {
            this.section = section;
            this.httpMethod = httpMethod;
        }

        public Method to(String javaMethodName) {
            this.javaMethodName = javaMethodName;
            return this;
        }

        private void add(Parameter parameter) {
            if (this.parameterNames.contains(parameter.key)) {
                throw new IllegalStateException("key '" + parameter.key + "' already defined");
            }
            this.parameterNames.add(parameter.key);
            this.parameters.add(parameter);
        }

        public Method with(String key, Enum<?> value) {
            return this.with(key, value.name());
        }

        public Method with(String key, String value) {
            Parameter parameter = Parameter.with(key, value);
            this.add(parameter);
            return this;
        }

        public Method withDefaultNull(String key) {
            Parameter parameter = Parameter.withDefaultNull(key);
            this.add(parameter);
            return this;
        }

        public Method withRequired(String key) {
            Parameter parameter = Parameter.withRequired(key);
            this.add(parameter);
            return this;
        }

        public Method GET(String absoluteUrlPathTemplate) {
            return this.section.GET(absoluteUrlPathTemplate);
        }

        public Method POST(String absoluteUrlPathTemplate) {
            return this.section.POST(absoluteUrlPathTemplate);
        }

        public RouterBuilder done() {
            return this.section.done();
        }

        public Collection<? extends RestlessParameter> toRestlessParameters() {
            ArrayList<RestlessParameter> restlessParameters = new ArrayList<RestlessParameter>();
            for (Parameter p : this.parameters) {
                RestlessParameter restlessParameter = p.isRequired ? new RestlessParameter(p.key) : new RestlessParameter(p.key, p.value);
                restlessParameters.add(restlessParameter);
            }
            return restlessParameters;
        }

        public Method withPrepared(Parameter ... parameters) {
            assert (parameters != null);
            for (Parameter p : parameters) {
                this.add(p);
            }
            return this;
        }
    }

    public static class Parameter {
        private boolean isRequired = false;
        String key;
        String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private Parameter(String key) {
            this.key = key;
            this.isRequired = true;
        }

        public static Parameter with(String key, Enum<?> value) {
            return Parameter.with(key, value.name());
        }

        public static Parameter with(String key, String value) {
            return new Parameter(key, value);
        }

        public static Parameter withDefaultNull(String key) {
            return Parameter.with(key, (String)null);
        }

        public static Parameter withRequired(String key) {
            return new Parameter(key);
        }
    }
}

