/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui;

import de.xam.texthtml.text.TextTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.xydra.index.query.Pair;

public class UrlTemplate {
    private final List<UrlPart> urlParts = new ArrayList<UrlPart>();

    private static UrlTemplate extend(UrlTemplate baseTemplate, Pair<String, ? extends Object> ... restrictedParameters) {
        UrlTemplate extended = new UrlTemplate();
        for (UrlPart part : baseTemplate.urlParts) {
            extended.urlParts.add(part.extend(restrictedParameters));
        }
        return extended;
    }

    private static UrlTemplate root(String pathPrefix) {
        UrlTemplate template = new UrlTemplate();
        template.path(pathPrefix);
        return template;
    }

    private UrlTemplate path(String pathSegment) {
        UrlPart part = new UrlPart();
        part.value = pathSegment;
        part.queryParameter = false;
        this.urlParts.add(part);
        return this;
    }

    private UrlTemplate pathParamOptional(String parameterName) {
        UrlPart part = new UrlPart();
        part.key = parameterName;
        part.required = false;
        part.queryParameter = false;
        this.urlParts.add(part);
        return this;
    }

    private UrlTemplate pathParamRequired(String parameterName) {
        UrlPart part = new UrlPart();
        part.key = parameterName;
        part.required = true;
        part.queryParameter = false;
        this.urlParts.add(part);
        return this;
    }

    private UrlTemplate queryParamOptional(String parameterName) {
        UrlPart part = new UrlPart();
        part.key = parameterName;
        part.required = false;
        part.queryParameter = true;
        this.urlParts.add(part);
        return this;
    }

    @Test
    public void test() {
        String prefix = "foo";
        UrlTemplate root = UrlTemplate.root("foo");
        UrlTemplate item = root.path("item").pathParamRequired("itemId").pathParamOptional("command");
        UrlTemplate edit = UrlTemplate.extend(item, Pair.create((Object)"command", (Object)"edit")).queryParamOptional("start").queryParamOptional("end");
        String someEditUrl = edit.with("itemId", "abc").with("start", 0).with("end", 95).url();
        Assert.assertEquals((Object)"/foo/item/abc/edit?start=0&end=95", (Object)someEditUrl);
    }

    private UrlBuilder with(String parameterName, Object o) {
        UrlBuilder urlBuilder = new UrlBuilder(this);
        return urlBuilder.with(parameterName, o);
    }

    private class UrlPart {
        String key;
        boolean queryParameter = true;
        boolean required = false;
        Object value = null;

        private UrlPart() {
        }

        public UrlPart extend(Pair<String, ? extends Object> ... restrictedParameters) {
            UrlPart copy = new UrlPart();
            copy.key = this.key;
            copy.value = this.value;
            copy.required = this.required;
            copy.queryParameter = this.queryParameter;
            if (restrictedParameters != null) {
                for (Pair<String, ? extends Object> pair : restrictedParameters) {
                    if (!((String)pair.getFirst()).equals(copy.key)) continue;
                    copy.value = pair.getSecond();
                }
            }
            return copy;
        }

        public String toString() {
            return (this.queryParameter ? "?" : "/") + this.key + "='" + this.value + "'" + (this.required ? "!" : "?");
        }
    }

    class UrlBuilder {
        private final UrlTemplate urlTemplate;
        private final Map<String, Object> values = new HashMap<String, Object>();

        private UrlBuilder(UrlTemplate urlTemplate2) {
            this.urlTemplate = urlTemplate2;
        }

        public String url() {
            StringBuilder b = new StringBuilder();
            boolean inQuery = false;
            for (UrlPart part : this.urlTemplate.urlParts) {
                Object o;
                Object value = part.value;
                if (part.key != null && (o = this.values.get(part.key)) != null) {
                    value = o;
                }
                if (part.queryParameter) {
                    if (inQuery) {
                        b.append("&");
                    } else {
                        b.append("?");
                        inQuery = true;
                    }
                    b.append(part.key);
                    b.append("=");
                    if (value == null) continue;
                    b.append(TextTool.urlEncode((String)value.toString()));
                    continue;
                }
                assert (!inQuery);
                assert (value != null);
                b.append("/").append(value);
            }
            return b.toString();
        }

        public UrlBuilder with(String parameterName, Object value) {
            if (this.values.containsKey(parameterName)) {
                throw new IllegalStateException("parameter '" + parameterName + "' already defined");
            }
            this.values.put(parameterName, value);
            return this;
        }
    }
}

