/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xydra.csv.ICsvTable;
import org.xydra.csv.IRow;
import org.xydra.csv.IRowInsertionHandler;
import org.xydra.csv.ISparseTable;
import org.xydra.csv.WrongDatatypeException;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.csv.impl.memory.SparseTable;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TableCoreTools {
    private static Logger log = LoggerFactory.getLogger(TableCoreTools.class);
    public static Comparator<String> ALPHA_NUMERIC_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return 1;
            }
            if (b == null) {
                return -1;
            }
            try {
                long aNum = Long.parseLong(a);
                long bNum = Long.parseLong(b);
                return (int)(aNum - bNum);
            }
            catch (NumberFormatException numberFormatException) {
                return a.compareTo(b);
            }
        }
    };

    public static IRowInsertionHandler createGroupByTwoKeysRowInsertionHandler(final String keyColumnName1, final String keyColumnName2) {
        IRowInsertionHandler rowInsertionHandler = new IRowInsertionHandler(){
            long aggregated = 0L;
            Map<TwoKey, Row> compoundKeys2row = new HashMap<TwoKey, Row>(100);
            TwoKey keyColumnNames = new TwoKey(keyColumnName1, keyColumnName2);
            long processed = 0L;

            @Override
            public void afterRowInsertion(IRow row) {
            }

            @Override
            public boolean beforeRowInsertion(Row row) {
                String valueA;
                ++this.processed;
                if (this.processed % 1000L == 0L) {
                    log.info("Read aggregating processed " + this.processed + " rows, aggregated " + this.aggregated);
                }
                if ((valueA = row.getValue(this.keyColumnNames.a)) == null) {
                    return false;
                }
                String valueB = row.getValue(this.keyColumnNames.b);
                if (valueB == null) {
                    return false;
                }
                TwoKey compoundKey = new TwoKey(valueA, valueB);
                if (this.compoundKeys2row.containsKey(compoundKey)) {
                    IRow masterRow = this.compoundKeys2row.get(compoundKey);
                    masterRow.aggregate(row, new String[]{keyColumnName1, keyColumnName2});
                    ++this.aggregated;
                    return false;
                }
                this.compoundKeys2row.put(compoundKey, row);
                return true;
            }
        };
        return rowInsertionHandler;
    }

    public static Map<CompoundKey, CsvTable> groupBy(ICsvTable sourceTable, List<String> keyList) {
        CompoundKey keys = new CompoundKey(keyList);
        log.info("Re-sorting table into group tables.");
        long serialNumber = 1L;
        TreeMap<CompoundKey, CsvTable> groups = new TreeMap<CompoundKey, CsvTable>();
        for (IRow sourceRow : sourceTable) {
            LinkedList<String> compoundRowNameList = new LinkedList<String>();
            for (String key : keys) {
                compoundRowNameList.add(sourceRow.getValue(key));
            }
            CompoundKey compoundRowName = new CompoundKey(compoundRowNameList);
            CsvTable groupTable = (CsvTable)groups.get(compoundRowName);
            if (groupTable == null) {
                groupTable = new CsvTable();
                groups.put(compoundRowName, groupTable);
            }
            HashSet<String> relevantCols = new HashSet<String>();
            relevantCols.addAll(sourceTable.getColumnNames());
            Row groupRow = groupTable.getOrCreateRow("" + serialNumber++, true);
            for (String relevantCol : relevantCols) {
                groupRow.setValue(relevantCol, sourceRow.getValue(relevantCol), true);
            }
        }
        return groups;
    }

    public static void groupBy(ICsvTable sourceTable, List<String> keyList, List<String> sumList, List<String> averageList, List<String> rangeList, ICsvTable targetTable) {
        CompoundKey keys = new CompoundKey(keyList);
        CompoundKey sum = new CompoundKey(sumList);
        CompoundKey average = new CompoundKey(averageList);
        CompoundKey range = new CompoundKey(rangeList);
        log.info("Re-sorting table into group tables.");
        long serialNumber = 1L;
        TreeMap<CompoundKey, CsvTable> groups = new TreeMap<CompoundKey, CsvTable>();
        for (IRow sourceRow : sourceTable) {
            LinkedList<String> compoundRowNameList = new LinkedList<String>();
            for (String key : keys) {
                compoundRowNameList.add(sourceRow.getValue(key));
            }
            CompoundKey compoundRowName = new CompoundKey(compoundRowNameList);
            CsvTable groupTable = (CsvTable)groups.get(compoundRowName);
            if (groupTable == null) {
                groupTable = new CsvTable();
                groups.put(compoundRowName, groupTable);
            }
            HashSet<String> relevantCols = new HashSet<String>();
            relevantCols.addAll(sum.keyParts);
            relevantCols.addAll(average.keyParts);
            relevantCols.addAll(range.keyParts);
            Row groupRow = groupTable.getOrCreateRow("" + serialNumber++, true);
            for (String relevantCol : relevantCols) {
                groupRow.setValue(relevantCol, sourceRow.getValue(relevantCol), true);
            }
        }
        log.info("Aggregate group tables to target table.");
        for (CompoundKey groupKey : groups.keySet()) {
            double doubleResult;
            log.info("Use groupKey " + groupKey);
            IRow targetRow = targetTable.getOrCreateRow(groupKey.toString(), true);
            for (int i = 0; i < keys.keyParts.size(); ++i) {
                targetRow.setValue(keys.keyParts.get(i), groupKey.keyParts.get(i), true);
            }
            ICsvTable groupTable = (ICsvTable)groups.get(groupKey);
            targetRow.setValue("count", groupTable.rowCount(), true);
            for (String sumCol : sum) {
                long longResult = 0L;
                doubleResult = 0.0;
                for (IRow groupRow : groupTable) {
                    try {
                        longResult += groupRow.getValueAsLong(sumCol);
                    }
                    catch (WrongDatatypeException e) {
                        try {
                            doubleResult += groupRow.getValueAsDouble(sumCol);
                        }
                        catch (WrongDatatypeException e2) {
                            log.warn("Could not calculate sum in col " + sumCol, (Throwable)e2);
                        }
                    }
                }
                if (doubleResult == 0.0) {
                    targetRow.setValue(sumCol + "--sum", "" + (long)((double)longResult + doubleResult), true);
                    continue;
                }
                targetRow.setValue(sumCol + "--sum", "" + ((double)longResult + doubleResult), true);
            }
            for (String averageCol : average) {
                long longResult = 0L;
                doubleResult = 0.0;
                for (IRow groupRow : groupTable) {
                    try {
                        longResult += groupRow.getValueAsLong(averageCol);
                    }
                    catch (WrongDatatypeException e) {
                        try {
                            doubleResult += groupRow.getValueAsDouble(averageCol);
                        }
                        catch (WrongDatatypeException e2) {
                            log.warn("Could not calculate average in col " + averageCol, (Throwable)e2);
                        }
                    }
                }
                double ave = ((double)longResult + doubleResult) / (double)groupTable.rowCount();
                long rAve = (long)(ave * 1000.0);
                targetRow.setValue(averageCol + "--average", "" + rAve / 1000L + "." + rAve % 1000L, true);
                double _sum = 0.0;
                long n = 0L;
                for (IRow groupRow : groupTable) {
                    ++n;
                    double delta = 0.0;
                    try {
                        delta = (double)groupRow.getValueAsLong(averageCol) - ave;
                    }
                    catch (WrongDatatypeException e) {
                        try {
                            delta = groupRow.getValueAsDouble(averageCol) - ave;
                        }
                        catch (WrongDatatypeException e2) {
                            log.warn("Could not calculate average in col " + averageCol, (Throwable)e2);
                        }
                    }
                    delta *= delta;
                    _sum += delta;
                }
                double stdev = Math.sqrt(_sum / (double)n);
                long rStdev = (long)(stdev * 1000.0);
                targetRow.setValue(averageCol + "--stdev", "" + rStdev / 1000L + "." + rStdev % 1000L, true);
            }
            for (String rangeCol : range) {
                HashSet<String> seenValues = new HashSet<String>();
                for (IRow groupRow : groupTable) {
                    seenValues.add(groupRow.getValue(rangeCol));
                }
                targetRow.setValue(rangeCol + "--range", "" + seenValues.size(), true);
            }
        }
    }

    public static void transpose(SparseTable sourceTable, SparseTable targetTable) {
        for (String sourceColumnName : sourceTable.getColumnNames()) {
            for (IRow sourceRow : sourceTable) {
                String value = sourceRow.getValue(sourceColumnName);
                Row targetRow = targetTable.getOrCreateRow(sourceColumnName, true);
                targetRow.setValue(sourceRow.getKey(), value, true);
            }
        }
    }

    public static List<Row> sortByColumn(ISparseTable table, String sortKey) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        for (Row row : table) {
            rowList.add(row);
        }
        Collections.sort(rowList, new RowByColumnComparator(sortKey));
        return rowList;
    }

    public static class RowByColumnComparator
    implements Comparator<IRow> {
        private final String sortCol;

        public RowByColumnComparator(String sortCol) {
            this.sortCol = sortCol;
        }

        @Override
        public int compare(IRow a, IRow b) {
            String aVal = a.getValue(this.sortCol);
            String bVal = b.getValue(this.sortCol);
            return ALPHA_NUMERIC_COMPARATOR.compare(aVal, bVal);
        }
    }

    private static class TwoKey {
        final String a;
        final String b;

        public TwoKey(String a, String b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object other) {
            return other instanceof TwoKey && this.a.equals(((TwoKey)other).a) && this.b.equals(((TwoKey)other).b);
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }
    }

    private static class CompoundKey
    implements Iterable<String>,
    Comparable<CompoundKey> {
        final List<String> keyParts;

        public CompoundKey(List<String> keys) {
            this.keyParts = keys;
        }

        public boolean equals(Object other) {
            if (other instanceof CompoundKey) {
                CompoundKey otherKey = (CompoundKey)other;
                if (otherKey.keyParts.size() == this.keyParts.size()) {
                    for (int i = 0; i < this.keyParts.size(); ++i) {
                        if (this.keyParts.get(i).equals(otherKey.keyParts.get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.keyParts.size(); ++i) {
                hash += this.keyParts.get(i).hashCode();
            }
            return hash;
        }

        @Override
        public Iterator<String> iterator() {
            return this.keyParts.iterator();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.keyParts.size(); ++i) {
                buf.append(this.keyParts.get(i));
                if (i + 1 >= this.keyParts.size()) continue;
                buf.append("--");
            }
            return buf.toString();
        }

        @Override
        public int compareTo(CompoundKey other) {
            return ALPHA_NUMERIC_COMPARATOR.compare(this.toString(), other.toString());
        }
    }
}

