/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import org.xydra.csv.ICsvTable;
import org.xydra.csv.TableCoreTools;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class TableTools
extends TableCoreTools {
    private static Logger log = LoggerFactory.getLogger(TableTools.class);

    public static void merge(File a, File b, File mergeFile) throws IOException {
        CsvTable table = new CsvTable();
        table.readFrom(a);
        table.readFrom(b);
        table.writeTo(mergeFile);
    }

    public static void process(File startDirectory, ICsvTable table, FilenameFilter filenameFilter, IFileProcessor processor) throws IOException {
        for (File f : startDirectory.listFiles(filenameFilter)) {
            processor.process(table, f);
        }
        for (File f : startDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            TableTools.process(f, table, filenameFilter, processor);
        }
    }

    public static void main(String[] args) throws IOException {
        CsvTable test = new CsvTable();
        Row row1 = test.getOrCreateRow("row-1", true);
        row1.setValue("colA", "A1", true);
        row1.setValue("colB", "B1", true);
        row1.setValue("colC", "C1", true);
        Row row2 = test.getOrCreateRow("row-2", true);
        row2.setValue("colA", "A2", true);
        row2.setValue("colB", "B2", true);
        row2.setValue("colC", "C2", true);
        Row row3 = test.getOrCreateRow("row-3", true);
        row3.setValue("colA", "A3", true);
        row3.setValue("colB", "B3", true);
        row3.setValue("colC", "C3", true);
        test.dump();
        CsvTable t = new CsvTable();
        TableCoreTools.transpose(test, t);
        t.dump();
    }

    public static interface IFileProcessor {
        public void process(ICsvTable var1, File var2) throws IOException;
    }
}

