/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IMultipartFormDataHandler;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;

public class ProgressManager {
    private static final IMultipartFormDataHandler.IProgressReporter LOG_PROGRESS_REPORTER = new IMultipartFormDataHandler.IProgressReporter(){

        @Override
        public void reportProgress(String progressMessage) {
            log.debug("PROGRESS: " + progressMessage);
        }
    };
    public static IProgressBroker DEFAULT_PROGRESS_BROKER = new SingleMachineProgressBroker();
    private static final Logger log = LoggerFactory.getLogger(ProgressManager.class);
    public static final String NO_MESSAGE = "NO_MESSAGE";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    public static IMultipartFormDataHandler.IProgressReporter createDefaultProgressReporter(final String progressToken) {
        if (progressToken == null) {
            return LOG_PROGRESS_REPORTER;
        }
        return new IMultipartFormDataHandler.IProgressReporter(){

            @Override
            public void reportProgress(String progressMessage) {
                DEFAULT_PROGRESS_BROKER.appendProgress(progressToken, progressMessage);
            }
        };
    }

    public static synchronized void restless(Restless restless) {
        restless.addMethod("/_uploadProgress", "GET", ProgressManager.class, "getProgress", false, new RestlessParameter("progressToken"));
    }

    public static void getProgress(HttpServletResponse res, String progressToken) throws IOException {
        String progressMessage = DEFAULT_PROGRESS_BROKER.getProgress(progressToken);
        if (progressMessage == null) {
            progressMessage = NO_MESSAGE;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Error", e);
            }
        }
        res.setContentType("text/plain; charset=utf8");
        PrintWriter w = res.getWriter();
        ((Writer)w).write("" + progressMessage);
        ((Writer)w).close();
    }

    public static void reportProgress(IMultipartFormDataHandler.IProgressReporter progressReporter, String progressMessage) {
        if (progressReporter != null) {
            progressReporter.reportProgress(progressMessage);
        }
    }

    public static void reportProgressDone(IMultipartFormDataHandler.IProgressReporter progressReporter, boolean success) {
        ProgressManager.reportProgress(progressReporter, success ? SUCCESS : ERROR);
    }

    public static void reportException(IMultipartFormDataHandler.IProgressReporter pr, Throwable e) {
        if (pr == null) {
            return;
        }
        pr.reportProgress("Exception " + e);
        log.warn("Exception: ", e);
        ProgressManager.reportProgressDone(pr, false);
    }

    public static final class SingleMachineProgressBroker
    implements IProgressBroker {
        private final Map<String, String> map = new HashMap<String, String>();

        @Override
        public void appendProgress(String progressToken, String progressMessage) {
            String recordedProgress;
            if (log.isDebugEnabled()) {
                log.debug("PROGRESS(" + progressToken + "): " + progressMessage);
            }
            if ((recordedProgress = this.map.get(progressToken)) == null) {
                this.map.put(progressToken, progressMessage);
            } else {
                String combinedProgress = recordedProgress + "\n\r" + progressMessage;
                this.map.put(progressToken, combinedProgress);
            }
        }

        @Override
        public void setProgress(String progressToken, String progressMessage) {
            if (log.isDebugEnabled()) {
                log.debug("PROGRESS(" + progressToken + "): " + progressMessage);
            }
            this.map.put(progressToken, progressMessage);
        }

        @Override
        public String getProgress(String progessToken) {
            return this.map.get(progessToken);
        }
    }

    public static interface IProgressBroker {
        public void appendProgress(String var1, String var2);

        public void setProgress(String var1, String var2);

        public String getProgress(String var1);
    }
}

