/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);
    public static final int MANY_DAYS = 25920000;

    public static void dumpCookies(HttpServletRequest req, Writer w) throws IOException {
        w.write("<style>td, th { border: 1px solid black; margin: 0px; padding: 2px;}</style>");
        w.write("<table><tr><th>Domain</th><th>Path</th><th>Secure?</th><th>Name</th><th>Value</th><th>MaxAge</th><th>Comment</th><th>Version</th></tr>");
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null) continue;
                w.write("<tr><td>" + cookie.getDomain() + "</td>" + "<td>" + cookie.getPath() + "</td>" + "<td>" + cookie.getSecure() + "</td>" + "<td>" + cookie.getName() + "</td>" + "<td>" + cookie.getValue() + "</td>" + "<td>" + cookie.getMaxAge() + "</td>" + "<td>" + cookie.getComment() + "</td>" + "<td>" + cookie.getVersion() + "</td>" + "</tr>");
            }
        }
        w.write("</table>");
    }

    public static String getCookie(HttpServletRequest req, String name) {
        if (req.getCookies() == null) {
            return null;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static Cookie getCookieObject(HttpServletRequest req, String cookieName) {
        if (req.getCookies() == null) {
            return null;
        }
        for (Cookie cookie : req.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie;
        }
        return null;
    }

    public static boolean hasCookie(HttpServletRequest req, String name) {
        if (req.getCookies() == null) {
            return false;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !cookie.getName().equals(name)) continue;
                if (cookie.getValue() == null) {
                    log.warn("cookie '" + name + "' is present but contains null");
                    return false;
                }
                if (cookie.getValue().equals("")) {
                    log.warn("cookie '" + name + "' is present but contains empty string");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static List<String> listCookieNames(HttpServletRequest req) {
        LinkedList<String> cookieNames = new LinkedList<String>();
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                assert (cookie != null);
                cookieNames.add(cookie.getName());
            }
        }
        return cookieNames;
    }

    public static void removeCookieIfPresent(HttpServletRequest req, HttpServletResponse res, String name, String domain) {
        assert (req != null);
        Cookie[] cookies = req.getCookies();
        if (cookies != null && CookieUtils.hasCookie(req, name)) {
            CookieUtils.setCookie(res, name, "", domain, null, 0);
        }
    }

    public static void setCookie(HttpServletResponse res, String name, String value, String domain, String comment, boolean persist) {
        CookieUtils.setCookie(res, name, value, domain, comment, persist ? 25920000 : -1);
    }

    public static void setCookie(HttpServletResponse res, String name, String value, String domain, String comment, int maxAge) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        if (comment != null) {
            cookie.setComment(comment);
        }
        res.addCookie(cookie);
    }

    public static void setCookieIfNecessary(HttpServletRequest req, HttpServletResponse res, String name, String value, String domain, String comment) {
        String currentCuid = CookieUtils.getCookie(req, name);
        if (currentCuid == null || !currentCuid.equals(value)) {
            CookieUtils.setCookie(res, name, value, domain, comment, true);
        }
    }
}

