/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.restless.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.SharedHtmlUtils;

public class HtmlUtils
extends SharedHtmlUtils {
    public static void writeHtmlHeaderOpenBody(Writer w, String title, SharedHtmlUtils.HeadChild ... headChildren) throws IOException {
        w.write("<!DOCTYPE html>\r\n<html>\r\n  <head>\r\n    <title>" + title + "</title>\r\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + "utf-8" + "\" />\r\n");
        if (headChildren != null) {
            for (SharedHtmlUtils.HeadChild headChild : headChildren) {
                w.write("    " + headChild.toString() + "\r\n");
            }
        }
        w.write("  </head>\r\n<body><div>\r\n");
    }

    public static void writeCloseBodyHtml(Writer w) throws IOException {
        w.write("</div></body>\r\n</html>");
        w.flush();
    }

    public static void writeHtmlPage(HttpServletResponse res, String title, String content) throws IOException {
        Writer w = HtmlUtils.startHtmlPage(res, title, new SharedHtmlUtils.HeadChild[0]);
        w.write(content);
        HtmlUtils.endHtmlPage(w);
    }

    public static void endHtmlPage(Writer w) throws IOException {
        HtmlUtils.writeCloseBodyHtml(w);
        w.close();
    }

    public static Writer startHtmlPage(HttpServletResponse res, String title, SharedHtmlUtils.HeadChild ... headChildren) throws IOException {
        ServletUtils.headers(res, "text/html");
        PrintWriter w = res.getWriter();
        HtmlUtils.writeHtmlHeaderOpenBody(w, title, headChildren);
        ((Writer)w).flush();
        return w;
    }

    public static Writer startHtmlPage(HttpServletResponse res, int statusCode, String title, SharedHtmlUtils.HeadChild ... headChildren) throws IOException {
        ServletUtils.headers(res, statusCode, -1L, "text/html");
        PrintWriter w = res.getWriter();
        HtmlUtils.writeHtmlHeaderOpenBody(w, title, headChildren);
        ((Writer)w).flush();
        return w;
    }

    public static String scriptRedirect(String redirectUrl, int redirectWaitMs) {
        String redirMarker = "#";
        return "<script type='text/javascript'>\nfunction redir() { \nif( (window.location+'').indexOf('#')==-1) { window.location = '" + redirectUrl + "#" + "'; }\n" + "}\n" + "setTimeout('redir()'," + redirectWaitMs + ");\n" + "</script>\n";
    }

    public static void writeInTheMiddleOfAResponse(Writer w, String messageHtml, String redirectUrl, int redirectWaitMs) throws IOException {
        w.write("<div style='position:absolute; left:20px; top:20px;z-index: 1000;padding: 10px;background-color: #FFC;font-family: sans-serif;border: 1px solid #999;max-width: 480px;word-break: break-all;'>");
        w.write("<a style='line-height: normal;padding: 9px 14px 9px;-webkit-border-radius: 6px;font-size: 30px;border: 2px solid;text-align: center;display: block;min-height: 70px;word-wrap: break-word;color: white;text-decoration: none;border-radius: 2px;border-color: rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.25);color: white;background-color: #0064CD;background-image: -webkit-linear-gradient(top, #049cdb, #0064cd);background-image: -o-linear-gradient(top, #049cdb, #0064cd);background-image: linear-gradient(top, #049cdb, #0064cd);text-shadow: 0 -1px 0 rgba(0, 0, 0, 0.25);' href='" + redirectUrl + "'>Oops. Click here to continue.</a><br/>");
        w.write(messageHtml);
        w.write(HtmlUtils.scriptRedirect(redirectUrl, redirectWaitMs));
        w.write("</div>");
        w.flush();
        HtmlUtils.endHtmlPage(w);
    }

    public static void script(Writer w, String scriptCode) throws IOException {
        w.write("<script type='text/javascript'>\n");
        w.write(scriptCode);
        w.write("\n</script>\n");
    }
}

