/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.IStreamSource;
import com.calpano.kgif.io.common.IStreamTransformer;
import com.calpano.kgif.io.common.ITempFileProvider;
import com.calpano.kgif.io.common.impl.FileStreamSink;
import com.calpano.kgif.io.common.impl.FileStreamSource;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.write.WritingEntityHandler;
import de.xam.mybase.model.IoProgressReporter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractImporterToEntityHandler
implements IKgifStreamImporter,
IStreamTransformer {
    protected ITempFileProvider tempFileProvider;

    public void setTempFileProvider(ITempFileProvider tempFileProvider) {
        this.tempFileProvider = tempFileProvider;
    }

    @Override
    public void transform(IStreamSource source, IStreamSink sink, IoProgressReporter iop) throws IOException {
        try (Writer writer = sink.openWriter();
             WritingEntityHandler entityHandler = new WritingEntityHandler(writer);){
            this.transformToEntityHandler(source, (IEntityHandler)entityHandler, iop);
        }
    }

    public abstract void transformToEntityHandler(IStreamSource var1, IEntityHandler var2, IoProgressReporter var3) throws IOException;

    @Override
    public IRepeatableStreamSource convertToKgif1_1_0(IRepeatableStreamSource source, IoProgressReporter iop) throws IOException {
        File tempFile = this.tempFileProvider.createTempFile("convert");
        FileStreamSink fileSink = new FileStreamSink(tempFile);
        this.transform(source, fileSink, iop);
        fileSink.close();
        FileStreamSource fileSource = new FileStreamSource(tempFile);
        return fileSource;
    }
}

