/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.common.impl;

import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.impl.AbstractStreamSource;
import de.xam.texthtml.text.Unicodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class MemorySinkToSource
extends AbstractStreamSource
implements IRepeatableStreamSource,
IStreamSink {
    private static final int MB_1 = 0x100000;
    private static final int INITIAL_BUFFER_SIZE = 0x100000;
    private final String sinkName;
    private ByteArrayOutputStream bos;
    protected boolean written = false;
    protected OutputStreamWriter writer = null;

    public MemorySinkToSource(String name) {
        this.sourceName = name + "-source";
        this.sinkName = name + "-sink";
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (!this.written) {
            throw new IllegalStateException("Content has not been written completely. Close() the output stream first.");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        return bis;
    }

    @Override
    public long getLastModificationDateUTC() {
        return -1L;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public String getSinkName() {
        return this.sinkName;
    }

    @Override
    public OutputStream openOutputStream() throws IOException, IllegalStateException {
        if (this.bos != null) {
            throw new IllegalStateException("outputstream was already open");
        }
        this.bos = new ByteArrayOutputStream(0x100000){

            @Override
            public void close() throws IOException {
                MemorySinkToSource.this.written = true;
            }
        };
        return this.bos;
    }

    @Override
    public Writer openWriter() throws IOException, IllegalStateException {
        if (this.writer != null) {
            throw new IllegalStateException("writer was already open");
        }
        if (this.bos == null) {
            this.openOutputStream();
        }
        this.writer = new OutputStreamWriter((OutputStream)this.bos, Unicodes.UTF8);
        return this.writer;
    }
}

