/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.io.rdf;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.common.IKgifExporter;
import com.calpano.kgif.io.common.IKgifImporterExporter;
import com.calpano.kgif.io.common.IStreamSink;
import com.calpano.kgif.io.common.impl.AbstractExporter;
import com.calpano.kgif.io.common.util.KgifNIO;
import com.calpano.kgif.io.rdf.NTriples;
import com.calpano.kgif.io.rdf.RdfCommon;
import com.calpano.kgif.v1_1_0.gen.Content;
import com.calpano.kgif.v1_1_0.gen.Footer;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReads;
import de.xam.itemset.impl.ItemSets;
import de.xam.texthtml.text.JspWikiSyntax;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.rdfxml.util.RDFXMLPrettyWriter;
import org.xydra.index.EnumUtils;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public abstract class AbstractRdfExporter
extends AbstractExporter
implements IKgifExporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRdfExporter.class);
    private static final URI rdfs_label = new URIImpl("http://www.w3.org/2000/01/rdf-schema#label");
    private long generatedTriplesCount = 0L;
    private final Map<String, Resource> nodeId2rdfResource = new HashMap<String, Resource>();
    private final MapSetIndex<String, Object> nodeId2waitingLinkOrProperty = MapSetIndex.createWithFastEntrySets();
    private SortedMap<String, String> nsMap;
    private RDFWriter rdfWriter;
    private final Set<String> suppressedNodeIds = new HashSet<String>();

    public static void main(String[] args) throws RDFHandlerException {
        RDFXMLPrettyWriter w = new RDFXMLPrettyWriter((OutputStream)System.out);
        w.startRDF();
        w.handleComment("foo");
        StatementImpl s = new StatementImpl((Resource)new URIImpl("foo:Bar"), (URI)new URIImpl("foo:Blop"), (Value)new URIImpl("foo:Baz"));
        w.handleStatement((Statement)s);
        w.endRDF();
        System.out.flush();
    }

    private static Literal toRdfLiteral(String content, String contentType, Metadata metadata) {
        assert (content != null);
        String langTag = KgifReads.getMetadataAttribute((Metadata)metadata, (String)"rdf-langTag");
        String dataTypeUri = KgifReads.getMetadataAttribute((Metadata)metadata, (String)"rdf-dataTypeUri");
        assert (langTag == null || dataTypeUri == null) : "rdf does not allow both";
        LiteralImpl lit = langTag != null ? new LiteralImpl(content, langTag) : (dataTypeUri != null ? new LiteralImpl(content, (URI)new URIImpl(dataTypeUri)) : (contentType != null && !contentType.equals("http://www.w3.org/2001/XMLSchema#string") && JspWikiSyntax.isIri((String)contentType) ? new LiteralImpl(content, (URI)new URIImpl(contentType)) : new LiteralImpl(content)));
        return lit;
    }

    protected abstract RDFWriterFactory getWriterFactory();

    private boolean isSuppressed(Link link) {
        return this.exportConf != null && !this.exportConf.shouldExport(link);
    }

    private boolean isSuppressed(Node node) {
        if (this.exportConf == null) {
            return false;
        }
        return !this.exportConf.shouldExport(node);
    }

    private boolean isSuppressed(Property property) {
        return this.exportConf != null && !this.exportConf.shouldExport(property);
    }

    public void onDocumentEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        try {
            this.rdfWriter.endRDF();
            this.reportProgress("End of KGIF document");
            this.w.flush();
        }
        catch (RDFHandlerException e) {
            throw new IOException("RDF Output Error", e);
        }
    }

    public void onDocumentStart(IIoContext ioContext) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        try {
            this.rdfWriter.startRDF();
            this.reportProgress("Start of KGIF document");
        }
        catch (RDFHandlerException e) {
            throw new IOException("RDF Output Error", e);
        }
    }

    public void onFooter(IIoContext ioContext, Footer footer) {
    }

    private void onFoundNode(String nodeId, Resource resource) throws RDFHandlerException {
        this.nodeId2rdfResource.put(nodeId, resource);
        IEntrySet entrySet = this.nodeId2waitingLinkOrProperty.lookup((Object)nodeId);
        if (entrySet != null) {
            this.nodeId2waitingLinkOrProperty.deIndex((Object)nodeId);
            for (Object o : entrySet.toSet()) {
                this.processLinkOrProperty(o);
            }
        }
    }

    private void onFoundProperty(String nodeId, Literal lit) throws RDFHandlerException {
        IEntrySet entrySet = this.nodeId2waitingLinkOrProperty.lookup((Object)nodeId);
        if (entrySet != null) {
            this.nodeId2waitingLinkOrProperty.deIndex((Object)nodeId);
            for (Object obj : entrySet.toSet()) {
                this.processLinkOrProperty(obj);
            }
        }
    }

    public void onGraphEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        this.reportProgress("End of KGIF graph");
    }

    public void onGraphStart(IIoContext ioContext, Metadata metadata) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        this.reportProgress("Start of KGIF graph");
    }

    public void onHeader(IIoContext ioContext, Header header) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        assert (header != null);
        this.nsMap = new TreeMap<String, String>();
        this.nsMap.putAll(RdfCommon.NS_MAP_DEFAULTS);
        KgifNIO.getNamespacesToMap(header, this.nsMap);
        for (Map.Entry<String, String> entry : this.nsMap.entrySet()) {
            try {
                this.rdfWriter.handleNamespace(entry.getKey(), entry.getValue());
            }
            catch (RDFHandlerException e) {
                throw new KgifReadWriteException("Error", "onHeader", (Throwable)e);
            }
        }
        this.reportProgress("Done with KGIF header");
    }

    public void onLink(IIoContext ioContext, Link link) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        try {
            if (this.isSuppressed(link)) {
                return;
            }
            this.processLink(link);
        }
        catch (RDFHandlerException e) {
            throw new IOException("RDF Output Error", e);
        }
    }

    public void onNode(IIoContext ioContext, Node node) throws IOException, KgifReadWriteException {
        if (this.isSuppressed(node)) {
            this.onSuppresedNode(node.getId());
            return;
        }
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        try {
            if ("true".equals(KgifReads.getMetadataAttribute((Metadata)node.getMetadata(), (String)"pmodel-att-displayAsProperty"))) {
                Label label = node.getLabel();
                Object lit = label != null ? AbstractRdfExporter.toRdfLiteral(label.getContent(), label.getContentType(), node.getMetadata()) : new LiteralImpl("");
                this.onFoundProperty(node.getId(), (Literal)lit);
            } else {
                Label kgifLabel;
                String idSemanticsStr;
                IKgifImporterExporter.IdSemantics idSemantics;
                URIImpl sResource = null;
                String rdfResourceIdSourceSyntax = KgifReads.getMetadataAttribute((Metadata)node.getMetadata(), (String)"id-sourceSyntax");
                if (rdfResourceIdSourceSyntax != null && (idSemantics = (IKgifImporterExporter.IdSemantics)EnumUtils.valueOf(IKgifImporterExporter.IdSemantics.class, (String)(idSemanticsStr = KgifReads.getMetadataAttribute((Metadata)node.getMetadata(), (String)"id-semantics")))) != null) {
                    switch (idSemantics) {
                        case bnode: {
                            sResource = new BNodeImpl(rdfResourceIdSourceSyntax);
                            break;
                        }
                        case uri: {
                            sResource = new URIImpl(rdfResourceIdSourceSyntax);
                        }
                    }
                }
                if (sResource == null) {
                    String localNodeIdStr = rdfResourceIdSourceSyntax == null ? node.getId() : rdfResourceIdSourceSyntax;
                    String fullIdStr = ItemSets.expandNamespace((String)localNodeIdStr, this.nsMap, (String)":");
                    sResource = new URIImpl(fullIdStr);
                }
                if ((kgifLabel = node.getLabel()) != null && !"generated".equals(KgifReads.getMetadataAttribute((Metadata)node.getMetadata(), (String)"label-source"))) {
                    Literal lit = AbstractRdfExporter.toRdfLiteral(kgifLabel.getContent(), kgifLabel.getContentType(), node.getMetadata());
                    this.writeStatement((Resource)sResource, rdfs_label, (Value)lit);
                }
                List alternativeLabels = KgifReads.getMetadataAttributeAsList((Metadata)node.getMetadata(), (String)"rdf-alternativeLabel");
                for (String altLabel : alternativeLabels) {
                    Literal lit = NTriples.fromNTriplesLiteral(altLabel);
                    this.writeStatement((Resource)sResource, rdfs_label, (Value)lit);
                }
                this.onFoundNode(node.getId(), (Resource)sResource);
            }
        }
        catch (RDFHandlerException e) {
            throw new IOException("RDF Output Error", e);
        }
    }

    public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
        assert (this.rdfWriter != null) : "Call setOutputStream(...) first";
        try {
            if (this.isSuppressed(property)) {
                return;
            }
            this.processProperty(property);
        }
        catch (RDFHandlerException e) {
            throw new IOException("RDF Output Error", e);
        }
    }

    private void onSuppresedNode(String nodeId) {
        this.suppressedNodeIds.add(nodeId);
        IEntrySet links = this.nodeId2waitingLinkOrProperty.lookup((Object)nodeId);
        if (links != null) {
            Set set = links.toSet();
            this.nodeId2waitingLinkOrProperty.deIndex((Object)nodeId);
            for (Object obj : set) {
                String p;
                String s;
                if (obj instanceof Link) {
                    Link link = (Link)obj;
                    s = link.getFrom();
                    p = link.getType();
                    String o = link.getTo();
                    this.nodeId2waitingLinkOrProperty.deIndex((Object)s, (Object)link);
                    this.nodeId2waitingLinkOrProperty.deIndex((Object)p, (Object)link);
                    this.nodeId2waitingLinkOrProperty.deIndex((Object)o, (Object)link);
                    continue;
                }
                assert (obj instanceof Property);
                Property property = (Property)obj;
                s = property.getSourceEntityId();
                p = property.getKey();
                this.nodeId2waitingLinkOrProperty.deIndex((Object)s, (Object)property);
                this.nodeId2waitingLinkOrProperty.deIndex((Object)p, (Object)property);
            }
        }
    }

    private boolean processLink(Link link) throws RDFHandlerException {
        Resource oResource;
        Resource pResource;
        boolean canProcessNow = true;
        Resource sResource = this.nodeId2rdfResource.get(link.getFrom());
        if (sResource == null) {
            this.nodeId2waitingLinkOrProperty.index((Object)link.getFrom(), (Object)link);
            canProcessNow = false;
        }
        if ((pResource = this.nodeId2rdfResource.get(link.getType())) == null) {
            this.nodeId2waitingLinkOrProperty.index((Object)link.getType(), (Object)link);
            canProcessNow = false;
        }
        if ((oResource = this.nodeId2rdfResource.get(link.getTo())) == null) {
            this.nodeId2waitingLinkOrProperty.index((Object)link.getTo(), (Object)link);
            return false;
        }
        if (!canProcessNow) {
            return false;
        }
        this.writeStatement(sResource, (URI)pResource, (Value)oResource);
        return true;
    }

    private void processLinkOrProperty(Object o) throws RDFHandlerException {
        if (o instanceof Link) {
            this.processLink((Link)o);
        } else {
            assert (o instanceof Property);
            this.processProperty((Property)o);
        }
    }

    private void processProperty(Property property) throws RDFHandlerException {
        Resource pResource;
        boolean canProcessNow = true;
        Resource sResource = this.nodeId2rdfResource.get(property.getSourceEntityId());
        if (sResource == null) {
            this.nodeId2waitingLinkOrProperty.index((Object)property.getSourceEntityId(), (Object)property);
            canProcessNow = false;
        }
        if ((pResource = this.nodeId2rdfResource.get(property.getKey())) == null) {
            this.nodeId2waitingLinkOrProperty.index((Object)property.getKey(), (Object)property);
            canProcessNow = false;
        }
        if (!canProcessNow) {
            return;
        }
        Content content = property.getContent();
        Literal oLit = AbstractRdfExporter.toRdfLiteral(content.getContent(), content.getContentType(), property.getMetadata());
        this.writeStatement(sResource, (URI)pResource, (Value)oLit);
    }

    private void reportProgress(String progressMessage) {
        log.info("PROGRESS: " + progressMessage);
        if (this.iop != null) {
            this.iop.reportProgress(progressMessage);
        }
    }

    @Override
    public void setSink(IStreamSink sink) throws IOException {
        this.sink = sink;
        this.w = sink.openWriter();
        this.rdfWriter = this.getWriterFactory().getWriter(this.w);
    }

    private void writeStatement(Resource sResource, URI pURI, Value oValue) throws RDFHandlerException {
        StatementImpl stmt = new StatementImpl(sResource, pURI, oValue);
        this.rdfWriter.handleStatement((Statement)stmt);
        ++this.generatedTriplesCount;
        if (this.generatedTriplesCount % 1000L == 0L) {
            this.reportProgress("Wrote " + this.generatedTriplesCount + " triples ...");
        }
    }
}

