/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl;

import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFact;
import de.xam.cmodel.fact.CFactIndex;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.IChangeData;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.index.iterator.Iterators;

public class CombinedFactSet
implements CFactSet {
    private final CFactIndex primary;
    private final CFactSet secondary;

    public CombinedFactSet(CFactIndex primary, CFactSet secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void addFact(CFact symbol) {
        this.secondary.addFact(symbol);
    }

    @Override
    public void removeFact(CFact symbol) {
        this.secondary.removeFact(symbol);
    }

    @Override
    public void addSymbol(CSymbol symbol) {
        this.secondary.addSymbol(symbol);
    }

    @Override
    public void removeSymbol(CSymbol symbol) {
        this.secondary.removeSymbol(symbol);
    }

    @Override
    public boolean addTriple(CTriple triple) {
        return this.secondary.addTriple(triple);
    }

    @Override
    public boolean removeTriple(CTriple triple) {
        return this.secondary.removeTriple(triple);
    }

    public XId getId() {
        return this.secondary.getId();
    }

    @Override
    public Iterator<CSymbol> getSymbols() {
        return Iterators.setUnion(this.primary.getSymbols(), this.secondary.getSymbols());
    }

    @Override
    public Iterator<CEntity> getEntities() {
        Iterator primaryIt = this.primary.getEntities();
        Iterator<CEntity> secondaryIt = this.secondary.getEntities();
        return Iterators.setUnion((Iterator)primaryIt, secondaryIt);
    }

    @Override
    public Iterator<CTriple> getTriples() {
        return Iterators.setUnion((Iterator)this.primary.getTriples(), this.secondary.getTriples());
    }

    @Override
    public CFactSet getContextModel() {
        if (this.primary.getContextModel() == null) {
            return this.secondary.getWritableContextModel();
        }
        return new CombinedFactSet(this.primary.getContextModel(), this.secondary.getWritableContextModel());
    }

    @Override
    public IChangeData getChangeData() {
        return this.primary.getChangeData();
    }

    @Override
    public String dump() {
        this.primary.dump();
        this.secondary.dump();
        return "";
    }

    @Override
    public String toDebugString() {
        return this.primary.toDebugString() + this.secondary.toDebugString();
    }

    @Override
    public void removeFact(XId factId) {
        this.secondary.removeFact(factId);
    }

    @Override
    public CFactSet getWritableContextModel() {
        return this.secondary.getWritableContextModel();
    }

    @Override
    public void setContextModel(CFactSet context) {
        this.secondary.setContextModel(context);
    }

    @Override
    public CFact getFactById(XId factId) {
        CSymbol fact = this.getSymbolById(factId);
        return fact;
    }

    @Override
    public CSymbol getSymbolById(XId symbolId) {
        CSymbol symbol = this.primary.getSymbolById(symbolId);
        if (symbol != null) {
            return symbol;
        }
        return this.secondary.getSymbolById(symbolId);
    }

    @Override
    public void removeSymbol(XId symbolId) {
        this.secondary.removeSymbol(symbolId);
    }

    @Override
    public void addEntity(CEntity entity) {
        this.secondary.addEntity(entity);
    }
}

