/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.util;

import java.util.Iterator;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XBooleanValue;
import org.xydra.base.value.XIdSetValue;
import org.xydra.base.value.XIntegerValue;
import org.xydra.base.value.XLongListValue;
import org.xydra.base.value.XLongValue;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.base.value.XValueJavaUtils;
import org.xydra.index.iterator.NoneIterator;

public class XydraUtils {
    public static final long NULL_VALUE_AS_LONG = -1L;
    private static final int NULL_VALUE_AS_INT = -1;

    public static String toString(XValue value) throws IllegalStateException {
        if (value == null) {
            return null;
        }
        if (value instanceof XStringValue) {
            return ((XStringValue)value).contents();
        }
        if (value instanceof XAddress) {
            return ((XAddress)((XAddress)value).getValue()).toURI();
        }
        throw new IllegalStateException("content is not a native XStringValue but " + value.getType());
    }

    public static int toInt(XValue value) {
        if (value == null) {
            return -1;
        }
        if (!(value instanceof XIntegerValue)) {
            throw new IllegalStateException("content is not a native XIntegerValue but " + value.getType());
        }
        return ((XIntegerValue)value).contents();
    }

    public static long toLong(XValue value) {
        if (value == null) {
            return -1L;
        }
        if (!(value instanceof XLongValue)) {
            throw new IllegalStateException("content is not a native XLongValue but " + value.getType());
        }
        return ((XLongValue)value).contents();
    }

    public static long toLongIfPossible(XValue value) {
        if (value == null) {
            return -1L;
        }
        if (value instanceof XLongValue) {
            return XydraUtils.toLong(value);
        }
        if (value instanceof XStringValue) {
            String s = XydraUtils.toString(value);
            Long l = Long.parseLong(s);
            return l;
        }
        throw new IllegalStateException("content is a " + value.getType() + " - cannot convert to long");
    }

    public static long[] toLongArrayIfPossible(XValue value) {
        if (value == null) {
            return new long[0];
        }
        if (value instanceof XLongListValue) {
            return ((XLongListValue)value).contents();
        }
        if (value instanceof XStringValue) {
            String s = XydraUtils.toString(value);
            return XydraUtils.toLongArray(s);
        }
        throw new IllegalStateException("content is a " + value.getType() + " - cannot convert to long");
    }

    public static long[] toLongArray(String s) {
        String[] parts = s.split(" *[,] *");
        long[] l = new long[parts.length];
        for (int i = 0; i < l.length; ++i) {
            l[i] = Long.parseLong(parts[i]);
        }
        return l;
    }

    public static byte[] toByteArray(XValue value) {
        if (value instanceof XBinaryValue) {
            return ((XBinaryValue)value).getValue();
        }
        throw new IllegalStateException("content is not a native XBinaryValue");
    }

    public static boolean removeIdFromIdSetValue(XWritableObject xobject, XId fieldId, XId removeId) {
        XWritableField field = xobject.getField(fieldId);
        if (field == null) {
            return false;
        }
        XValue value = field.getValue();
        if (value == null) {
            return false;
        }
        assert (value instanceof XIdSetValue);
        boolean contains = ((XIdSetValue)value).contains((Object)removeId);
        value = ((XIdSetValue)value).remove(removeId);
        field.setValue(value);
        return contains;
    }

    public static boolean addIdToIdSetValue(XWritableObject xobject, XId fieldId, XId addId) {
        XWritableField field = xobject.createField(fieldId);
        XValue value = field.getValue();
        if (value != null) {
            assert (value instanceof XIdSetValue);
            value = ((XIdSetValue)value).add(addId);
        } else {
            value = XV.toIdSetValue((XId[])new XId[]{addId});
        }
        boolean change = field.setValue(value);
        assert (field.getValue() != null);
        return change;
    }

    public static Iterator<XId> getIdSetValue(XWritableObject xobject, XId fieldId) {
        XValue value = XydraUtils.getProperty(xobject, fieldId);
        if (value == null) {
            return NoneIterator.create();
        }
        assert (value instanceof XIdSetValue);
        return ((XIdSetValue)value).iterator();
    }

    public static XValue getProperty(XWritableObject xobject, XId fieldId) {
        XWritableField field = xobject.getField(fieldId);
        if (field == null) {
            return null;
        }
        XValue value = field.getValue();
        return value;
    }

    public static String getStringProperty(XWritableObject xobject, XId propertyId) {
        XValue value = XydraUtils.getProperty(xobject, propertyId);
        return XydraUtils.toString(value);
    }

    public static byte[] getBinaryProperty(XWritableObject xobject, XId propertyId) {
        XValue value = XydraUtils.getProperty(xobject, propertyId);
        return XydraUtils.toByteArray(value);
    }

    public static void setProperty(XWritableObject xobject, XId propertyId, long l) {
        XydraUtils.setProperty(xobject, propertyId, (XValue)XV.toValue((long)l));
    }

    public static boolean setProperty(XWritableObject xobject, XId propertyId, XValue value) {
        if (value == null) {
            return XydraUtils.removeProperty(xobject, propertyId) != null;
        }
        if (value instanceof XBooleanValue && !((XBooleanValue)value).contents()) {
            return xobject.removeField(propertyId);
        }
        assert (value != null);
        return xobject.createField(propertyId).setValue(value);
    }

    public static long getLongProperty(XWritableObject xobject, XId propertyId) {
        XValue value = XydraUtils.getProperty(xobject, propertyId);
        return XydraUtils.toLong(value);
    }

    public static XValue removeProperty(XWritableObject xobject, XId propertyId) {
        XWritableField field = xobject.getField(propertyId);
        if (field == null) {
            return null;
        }
        XValue value = field.getValue();
        xobject.removeField(propertyId);
        return value;
    }

    public static boolean setProperty(XWritableModel xmodel, XId objectId, XId propertyId, Object value) {
        XWritableObject xo = xmodel.createObject(objectId);
        XValue xvalue = XValueJavaUtils.toValue((Object)value);
        return XydraUtils.setProperty(xo, propertyId, xvalue);
    }

    public static boolean toBoolean(XValue value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof XBooleanValue)) {
            throw new IllegalStateException("content is not a native XBooleanValue but " + value.getType());
        }
        return ((XBooleanValue)value).contents();
    }

    public static boolean setFieldValue(XWritableObject xobject, XId fieldId, XValue value) {
        XWritableField field = xobject.createField(fieldId);
        assert (field != null);
        return field.setValue(value);
    }

    public static XValue getFieldValue(XReadableObject xobject, XId fieldId) {
        assert (xobject != null);
        XReadableField field = xobject.getField(fieldId);
        if (field == null) {
            return null;
        }
        return field.getValue();
    }
}

