/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.value.impl;

import de.xam.cmodel.util.ByteUtils;
import java.util.Arrays;
import org.xydra.base.XId;
import org.xydra.base.id.SimpleUTF8;
import org.xydra.base.value.ValueType;

public class ByteBasedIdImpl
implements XId {
    private static final long serialVersionUID = 5509763807895915445L;
    private final byte[] idBytes;
    private transient int hash;

    public ByteBasedIdImpl(byte[] bytes) {
        this.idBytes = bytes;
    }

    public ByteBasedIdImpl(String id) {
        this.idBytes = SimpleUTF8.toUtf8Bytes_fromAnyString((String)id);
        this.hash = id.hashCode();
    }

    public byte[] toBytes() {
        return this.idBytes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ByteBasedIdImpl) {
            ByteBasedIdImpl other = (ByteBasedIdImpl)obj;
            return Arrays.equals(this.idBytes, other.idBytes);
        }
        if (obj instanceof XId) {
            XId oId = (XId)obj;
            return this.toString().equals(oId.toString());
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0 && this.idBytes.length > 0) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return SimpleUTF8.toUtf8String((byte[])this.toBytes());
    }

    public ValueType getType() {
        return ValueType.Id;
    }

    public int compareTo(XId o) {
        assert (o != null);
        return ByteUtils.compareBytewise(this.toBytes(), o.toBytes());
    }

    public XId getId() {
        return this;
    }
}

