/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class Match<V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<String> matchedStrings = new HashSet<String>();
    private V value;
    public double q = -1.0;

    public String toString() {
        return "Match for '" + this.value + "' " + "q=" + this.q() + " strings=" + this.matchedStrings;
    }

    public Set<String> getMatchedStrings() {
        return this.matchedStrings;
    }

    public Match(V value) {
        assert (value != null);
        this.value = value;
    }

    public Match(V value, double q) {
        this(value);
        this.q = q;
    }

    public double q() {
        assert (this.q >= 0.0) : "q=" + this.q;
        return this.q;
    }

    public V getValue() {
        return this.value;
    }

    public void setQuality(double q) {
        this.q = q;
    }

    public void addMatchedString(String s) {
        this.matchedStrings.add(s);
    }

    public boolean hasMatchedString(String s) {
        return this.matchedStrings.contains(s);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Match other = (Match)obj;
        return other.value.equals(this.value);
    }
}

