/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.util;

import com.google.common.base.Function;
import com.google.gwt.regexp.shared.SplitResult;
import de.xam.textsearch.Match;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class TextIndexTool {
    public static final Function<String, Void> DO_NOTHING = new Function<String, Void>(){

        public Void apply(String input) {
            return null;
        }
    };

    public static List<String> generatePrefixes(String t, int minimalPrefixLength, int maximalPrefixLength) {
        LinkedList<String> result = new LinkedList<String>();
        if (t.length() < minimalPrefixLength) {
            return result;
        }
        int maxPrefixLen = Math.min(t.length(), maximalPrefixLength);
        for (int i = minimalPrefixLength; i <= maxPrefixLen; ++i) {
            String subString = t.substring(0, i);
            result.add(subString);
        }
        return result;
    }

    public static Set<String> generateSubstrings(String token, int minimalSubStringLength, int maximalSubstringLength) {
        HashSet<String> result = new HashSet<String>();
        if (token.length() < minimalSubStringLength) {
            result.add(token);
            return result;
        }
        int maxSubStringLen = Math.min(token.length(), maximalSubstringLength);
        for (int subStringLen = minimalSubStringLength; subStringLen <= maxSubStringLen; ++subStringLen) {
            int slicesMax = token.length() - subStringLen + 1;
            for (int i = 0; i < slicesMax; ++i) {
                String subString = token.substring(i, i + subStringLen);
                result.add(subString);
            }
        }
        return result;
    }

    public static <V> Set<V> toSet(Iterator<Match<V>> matches) {
        HashSet<V> resSet = new HashSet<V>();
        while (matches.hasNext()) {
            Match<V> match = matches.next();
            resSet.add(match.getValue());
        }
        return resSet;
    }

    public static <T> void dump(Iterator<Match<T>> searchResult) {
        System.out.println("Match Iterator:");
        while (searchResult.hasNext()) {
            Match<T> match = searchResult.next();
            System.out.println("Found val='" + match.getValue() + "' q=" + match.q() + " matched=" + match);
        }
    }

    public static int sumOfStringLengths(Collection<String> stringSet) {
        int i = 0;
        for (String s : stringSet) {
            i += s.length();
        }
        return i;
    }

    public static class SplitResultIterator
    implements Iterator<String> {
        private final SplitResult data;
        private int cursor = 0;

        public SplitResultIterator(SplitResult data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.data.length();
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                return this.data.get(this.cursor++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

