/*
 * Decompiled with CFR 0.152.
 */
package de.xam.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Exec {
    private static final Logger log = LoggerFactory.getLogger(Exec.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeVarargs
    public static Result execute(File workDir, String command, long maxMillis, boolean captureOutStream, boolean captureErrStream, boolean showOutStream, boolean showErrStream, Pair<String, String> ... env) {
        Result result;
        Object[] envPairs = null;
        if (env != null) {
            envPairs = new String[env.length];
            for (int i = 0; i < envPairs.length; ++i) {
                Pair<String, String> pair = env[i];
                envPairs[i] = (String)pair.getFirst() + "=" + (String)pair.getSecond();
            }
        } else {
            envPairs = new String[]{};
        }
        log.info("Executing = " + command);
        log.info("WorkDir   = " + (workDir == null ? "--" : workDir.getAbsolutePath()));
        log.info("Env       = " + Arrays.toString(envPairs));
        Runtime runtime = Runtime.getRuntime();
        InputStream processIn = null;
        InputStream processErr = null;
        OutputStream processOut = null;
        Thread killThread = null;
        try {
            log.info("--- Command Output --- 8< --------------- Command running ...");
            final Process process = runtime.exec(command, (String[])envPairs, workDir);
            processIn = process.getInputStream();
            processErr = process.getErrorStream();
            processOut = process.getOutputStream();
            Thread runThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            killThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    process.destroy();
                }
            });
            Runtime.getRuntime().addShutdownHook(killThread);
            runThread.start();
            long startMs = System.currentTimeMillis();
            boolean timeLeft = true;
            boolean isDone = false;
            StringBuilder outStream = new StringBuilder();
            StringBuilder errStream = new StringBuilder();
            while (timeLeft && !isDone) {
                timeLeft = System.currentTimeMillis() < startMs + maxMillis;
                try {
                    process.exitValue();
                    isDone = true;
                }
                catch (IllegalThreadStateException e) {
                    isDone = false;
                }
                while (processIn.available() > 0) {
                    char c = (char)processIn.read();
                    if (captureOutStream) {
                        outStream.append(c);
                    }
                    if (!showOutStream) continue;
                    System.out.print(c);
                }
                if (showOutStream) {
                    System.out.flush();
                }
                while (processErr.available() > 0) {
                    char c = (char)processErr.read();
                    if (captureErrStream) {
                        errStream.append(c);
                    }
                    if (!showErrStream) continue;
                    System.err.print(c);
                }
                if (showErrStream) {
                    System.err.flush();
                }
                while (System.in.available() > 0) {
                    processOut.write(new byte[]{(byte)System.in.read()});
                }
                if (isDone) continue;
                long secondsLeft = (startMs + maxMillis - System.currentTimeMillis()) / 1000L;
                if (secondsLeft % 10L == 0L) {
                    log.info(secondsLeft + " seconds left for '" + command + "'");
                }
                Thread.sleep(1000L);
            }
            Result result2 = new Result();
            result2.timeInMillis = System.currentTimeMillis() - startMs;
            if (isDone) {
                result2.started = true;
                result2.timeOut = false;
                result2.statusCode = process.exitValue();
            } else {
                result2.started = false;
                result2.timeOut = true;
                result2.statusCode = -1;
                runThread.interrupt();
                process.destroy();
            }
            result2.outStream = outStream;
            result2.errStream = errStream;
            log.info("---------------------------------- >8 --- ... Command Done.  ");
            log.info("Result = " + result2);
            result = result2;
            if (killThread != null) {
                Runtime.getRuntime().removeShutdownHook(killThread);
            }
        }
        catch (IOException | InterruptedException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (killThread != null) {
                    Runtime.getRuntime().removeShutdownHook(killThread);
                }
                try {
                    if (processErr != null) {
                        processErr.close();
                    }
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
                try {
                    if (processOut != null) {
                        processOut.close();
                    }
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
                try {
                    if (processIn == null) throw throwable;
                    processIn.close();
                    throw throwable;
                }
                catch (IOException e4) {
                    throw new RuntimeException(e4);
                }
            }
        }
        try {
            if (processErr != null) {
                processErr.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (processOut != null) {
                processOut.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (processIn == null) return result;
            processIn.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @SafeVarargs
    public static Result execute(File workDir, String command, Pair<String, String> ... env) {
        return Exec.execute(workDir, command, 600000L, true, true, true, true, env);
    }

    public static class Result {
        public StringBuilder errStream;
        public StringBuilder outStream;
        public static final Result DO_NOTHING = Result.create(true, 0, 0, false);
        boolean started;
        long timeInMillis;
        int statusCode;
        boolean timeOut;

        private Result() {
        }

        public String toString() {
            return "Result [ok=" + this.started + ", timeInMillis=" + this.timeInMillis + ", statusCode=" + this.statusCode + ", timeOut=" + this.timeOut + "]";
        }

        private static Result create(boolean started, int statusCode, int timeInMillis, boolean timeOut) {
            Result r = new Result();
            r.started = started;
            r.statusCode = statusCode;
            r.timeInMillis = timeInMillis;
            r.timeOut = timeOut;
            return r;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public boolean isOK() {
            return this.started && this.getStatusCode() == 0;
        }

        public boolean isTimeout() {
            return this.timeOut;
        }

        public void markAsFailed() {
            this.started = false;
        }
    }
}

