/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Quad;
import org.semanticweb.yars.nx.Resource;

public class Triple
implements Serializable {
    protected Node _pred;
    protected Node _sub;
    protected Node _obj;
    public static final long serialVersionUID = 1L;

    public Triple(Node subject, Node predicate, Node object) {
        this._sub = subject;
        this._pred = predicate;
        this._obj = object;
    }

    public Triple(Triple s) {
        this._sub = s.getSubject();
        this._pred = s.getPredicate();
        this._obj = s.getObject();
    }

    public static Triple fromArray(Node[] na) {
        if (na.length == 3) {
            return new Triple(na[0], na[1], na[2]);
        }
        if (na.length == 4) {
            return Quad.fromArray(na);
        }
        return null;
    }

    public Node[] toArray() {
        Node[] n = new Node[]{this.getSubject(), this.getPredicate(), this.getObject()};
        return n;
    }

    public Node getObject() {
        return this._obj;
    }

    public Node getPredicate() {
        return this._pred;
    }

    public Node getSubject() {
        return this._sub;
    }

    public void setObject(Node l) {
        this._obj = l;
    }

    public void setPredicate(Resource l) {
        this._pred = l;
    }

    public void setSubject(Node l) {
        this._sub = l;
    }

    public String toString() {
        return this.toN3();
    }

    public String toN3() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._sub.toN3());
        buf.append(" ");
        buf.append(this._pred.toN3());
        buf.append(" ");
        buf.append(this._obj.toN3());
        buf.append(" .");
        return buf.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o != null && o instanceof Triple;
        if (result) {
            Triple s = (Triple)o;
            result &= s._sub.equals(this._sub) && s._pred.equals(this._pred) && s._obj.equals(this._obj);
        }
        return result;
    }

    public int hashCode() {
        return this.toN3().hashCode();
    }
}

