/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.InputStream;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.cli.Main;
import org.semanticweb.yars.nx.parser.NxParser;

public class CheckSorted {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        Main.addInputOption(options, "i", "sorted input");
        Main.addTicksOption(options);
        Main.addHelpOption(options);
        Option sortOrderO = new Option("so", "sort order: e.g. 0123 for SPOC 3012 for CSPO (written order preserved)");
        sortOrderO.setArgs(1);
        sortOrderO.setRequired(false);
        options.addOption(sortOrderO);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("***ERROR: " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        if (cmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("parameters:", options);
            return;
        }
        InputStream is = Main.getMainInputStream(cmd);
        int ticks = Main.getTicks(cmd);
        NxParser it = new NxParser(is);
        NodeComparator nc = NodeComparator.NC;
        if (cmd.hasOption("so")) {
            nc = new NodeComparator(Main.getMask(cmd.getOptionValue("so")));
        }
        int count = 1;
        boolean fine = true;
        if (it.hasNext()) {
            Node[] nxold = (Node[])it.next();
            while (it.hasNext()) {
                Node[] nx;
                if (ticks > 0 && ++count % ticks == 0) {
                    System.err.println("Read " + count);
                }
                if (nc.compare(nxold, nx = (Node[])it.next()) > 0) {
                    System.err.println(Nodes.toN3(nxold) + " before " + Nodes.toN3(nx));
                    fine = false;
                }
                nxold = nx;
            }
        }
        System.err.println("Read " + count);
        if (fine) {
            System.err.println("Passed");
        }
    }
}

