/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt;

import java.util.HashMap;
import java.util.TreeSet;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeFactory;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.dt.UnsupportedDatatypeException;
import org.semanticweb.yars.nx.namespace.XSD;
import org.semanticweb.yars.nx.parser.NxParser;

public class XSDDatatypeMap {
    public static final HashMap<Resource, DatatypeElement> MAP = new HashMap();

    public static boolean isSubtype(Resource sup, Resource sub) throws UnsupportedDatatypeException {
        DatatypeElement supde = MAP.get(sup);
        DatatypeElement subde = MAP.get(sub);
        if (supde == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + sup);
        }
        if (subde == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + sup);
        }
        return DatatypeElement.isSubtype(supde, subde);
    }

    public static Resource getPrimitive(Resource dt) {
        DatatypeElement dte = MAP.get(dt);
        if (dte == null) {
            return dt;
        }
        return dte.getPrimitive().getURI();
    }

    public static Literal getCanonicalLiteral(Literal l) throws DatatypeParseException {
        if (l.getDatatype() != null && Datatype.isSupportedStandardDatatype(l.getDatatype())) {
            Resource primitiveDT = XSDDatatypeMap.getPrimitive(l.getDatatype());
            if (primitiveDT == null) {
                return l;
            }
            Datatype<? extends Object> d = DatatypeFactory.getDatatype(l.getUnescapedData(), primitiveDT);
            if (d == null) {
                return l;
            }
            String canon = d.getCanonicalRepresentation();
            if (!canon.equals(l.getUnescapedData()) || !primitiveDT.equals(l.getDatatype())) {
                return new Literal(NxParser.escapeForNx(canon), primitiveDT);
            }
        }
        return l;
    }

    public static boolean areDisjoint(Resource dt1, Resource dt2) throws UnsupportedDatatypeException {
        if (dt1.equals(dt2)) {
            return false;
        }
        if (dt1 == null && dt2.equals(XSD.STRING)) {
            return false;
        }
        if (dt2 == null && dt1.equals(XSD.STRING)) {
            return false;
        }
        DatatypeElement de1 = MAP.get(dt1);
        DatatypeElement de2 = MAP.get(dt2);
        if (de1 == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + dt1);
        }
        if (de2 == null) {
            throw new UnsupportedDatatypeException("Unsupported datatype " + dt2);
        }
        return DatatypeElement.areDisjoint(de1, de2);
    }

    public static void main(String[] args) throws UnsupportedDatatypeException {
        System.err.println(XSDDatatypeMap.areDisjoint(XSD.BOOLEAN, new Resource("http://www.w3.org/2001/XMLSchema#boolean")));
    }

    static {
        DatatypeElement anyuri = new DatatypeElement(XSD.ANYURI, null);
        MAP.put(XSD.ANYURI, anyuri);
        DatatypeElement base64binary = new DatatypeElement(XSD.BASE64BINARY, null);
        MAP.put(XSD.BASE64BINARY, base64binary);
        DatatypeElement booleaN = new DatatypeElement(XSD.BOOLEAN, null);
        MAP.put(XSD.BOOLEAN, booleaN);
        DatatypeElement date = new DatatypeElement(XSD.DATE, null);
        MAP.put(XSD.DATE, date);
        DatatypeElement datetime = new DatatypeElement(XSD.DATETIME, null);
        MAP.put(XSD.DATETIME, datetime);
        DatatypeElement datetimestamp = new DatatypeElement(XSD.DATETIMESTAMP, datetime);
        MAP.put(XSD.DATETIMESTAMP, datetimestamp);
        datetime.addSubtype(datetimestamp);
        DatatypeElement decimal = new DatatypeElement(XSD.DECIMAL, null);
        MAP.put(XSD.DECIMAL, decimal);
        DatatypeElement integer = new DatatypeElement(XSD.INTEGER, decimal);
        MAP.put(XSD.INTEGER, integer);
        decimal.addSubtype(integer);
        DatatypeElement lonG = new DatatypeElement(XSD.LONG, decimal);
        MAP.put(XSD.LONG, lonG);
        integer.addSubtype(lonG);
        DatatypeElement inT = new DatatypeElement(XSD.INT, decimal);
        MAP.put(XSD.INT, inT);
        lonG.addSubtype(inT);
        DatatypeElement shorT = new DatatypeElement(XSD.SHORT, decimal);
        MAP.put(XSD.SHORT, shorT);
        inT.addSubtype(shorT);
        DatatypeElement bytE = new DatatypeElement(XSD.BYTE, decimal);
        MAP.put(XSD.BYTE, bytE);
        shorT.addSubtype(bytE);
        DatatypeElement nonnegativeinteger = new DatatypeElement(XSD.NONNEGATIVEINTEGER, decimal);
        MAP.put(XSD.NONNEGATIVEINTEGER, nonnegativeinteger);
        integer.addSubtype(nonnegativeinteger);
        DatatypeElement positiveinteger = new DatatypeElement(XSD.POSITIVEINTEGER, decimal);
        MAP.put(XSD.POSITIVEINTEGER, positiveinteger);
        nonnegativeinteger.addSubtype(positiveinteger);
        DatatypeElement unsignedlong = new DatatypeElement(XSD.UNSIGNEDLONG, decimal);
        MAP.put(XSD.UNSIGNEDLONG, unsignedlong);
        nonnegativeinteger.addSubtype(unsignedlong);
        DatatypeElement unsignedint = new DatatypeElement(XSD.UNSIGNEDINT, decimal);
        MAP.put(XSD.UNSIGNEDINT, unsignedint);
        unsignedlong.addSubtype(unsignedint);
        DatatypeElement unsignedshort = new DatatypeElement(XSD.UNSIGNEDSHORT, decimal);
        MAP.put(XSD.UNSIGNEDSHORT, unsignedshort);
        unsignedint.addSubtype(unsignedshort);
        DatatypeElement unsignedbyte = new DatatypeElement(XSD.UNSIGNEDBYTE, decimal);
        MAP.put(XSD.UNSIGNEDBYTE, unsignedbyte);
        unsignedshort.addSubtype(unsignedbyte);
        DatatypeElement nonPositiveInteger = new DatatypeElement(XSD.NONPOSITIVEINTEGER, decimal);
        MAP.put(XSD.NONPOSITIVEINTEGER, nonPositiveInteger);
        integer.addSubtype(nonPositiveInteger);
        DatatypeElement negativeinteger = new DatatypeElement(XSD.NEGATIVEINTEGER, decimal);
        MAP.put(XSD.NEGATIVEINTEGER, negativeinteger);
        nonPositiveInteger.addSubtype(negativeinteger);
        DatatypeElement floaT = new DatatypeElement(XSD.FLOAT, null);
        MAP.put(XSD.FLOAT, floaT);
        DatatypeElement gday = new DatatypeElement(XSD.GDAY, null);
        MAP.put(XSD.GDAY, gday);
        DatatypeElement gmonth = new DatatypeElement(XSD.GMONTH, null);
        MAP.put(XSD.GMONTH, gmonth);
        DatatypeElement gmonthday = new DatatypeElement(XSD.GMONTHDAY, null);
        MAP.put(XSD.GMONTHDAY, gmonthday);
        DatatypeElement gyear = new DatatypeElement(XSD.GYEAR, null);
        MAP.put(XSD.GYEAR, gyear);
        DatatypeElement gyearmonth = new DatatypeElement(XSD.GYEARMONTH, null);
        MAP.put(XSD.GYEARMONTH, gyearmonth);
        DatatypeElement hexbinary = new DatatypeElement(XSD.HEXBINARY, null);
        MAP.put(XSD.HEXBINARY, hexbinary);
        DatatypeElement string = new DatatypeElement(XSD.STRING, null);
        MAP.put(XSD.STRING, string);
        DatatypeElement normalizedstring = new DatatypeElement(XSD.NORMALIZEDSTRING, string);
        MAP.put(XSD.NORMALIZEDSTRING, string);
        string.addSubtype(normalizedstring);
        DatatypeElement token = new DatatypeElement(XSD.TOKEN, string);
        MAP.put(XSD.TOKEN, token);
        normalizedstring.addSubtype(token);
        DatatypeElement language = new DatatypeElement(XSD.LANGUAGE, string);
        MAP.put(XSD.LANGUAGE, language);
        token.addSubtype(language);
        DatatypeElement name = new DatatypeElement(XSD.NAME, string);
        MAP.put(XSD.NAME, name);
        token.addSubtype(name);
        DatatypeElement ncname = new DatatypeElement(XSD.NCNAME, string);
        MAP.put(XSD.NCNAME, ncname);
        name.addSubtype(ncname);
        DatatypeElement nmtoken = new DatatypeElement(XSD.NMTOKEN, string);
        MAP.put(XSD.NMTOKEN, nmtoken);
        token.addSubtype(nmtoken);
        DatatypeElement time = new DatatypeElement(XSD.TIME, null);
        MAP.put(XSD.TIME, time);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatatypeElement
    implements Comparable<DatatypeElement> {
        private DatatypeElement _primitive;
        private Resource _uri;
        private TreeSet<DatatypeElement> _subtypes = null;

        public DatatypeElement(Resource uri, DatatypeElement primitive) {
            this._uri = uri;
            this._primitive = primitive;
        }

        public Resource getURI() {
            return this._uri;
        }

        public void addSubtype(DatatypeElement ... sub) {
            if (this._subtypes == null) {
                this._subtypes = new TreeSet();
            }
            for (DatatypeElement de : sub) {
                this._subtypes.add(de);
            }
        }

        @Override
        public int compareTo(DatatypeElement de2) {
            return this._uri.compareTo(de2._uri);
        }

        public boolean isPrimitive() {
            return this._primitive == null;
        }

        public DatatypeElement getPrimitive() {
            if (this.isPrimitive()) {
                return this;
            }
            return this._primitive;
        }

        public TreeSet<DatatypeElement> getSubtypes() {
            return this._subtypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DatatypeElement) {
                return this.equals((DatatypeElement)o);
            }
            return false;
        }

        public boolean equals(DatatypeElement de) {
            if (de == this) {
                return true;
            }
            return this._uri.equals(de._uri);
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean isSubtype(DatatypeElement de) {
            return DatatypeElement.isSubtype(this, de);
        }

        public TreeSet<DatatypeElement> getAllSubtypes() {
            return DatatypeElement.getAllSubtypes(this);
        }

        public static boolean isSubtype(DatatypeElement sup, DatatypeElement sub) {
            TreeSet<DatatypeElement> subs = sup.getAllSubtypes();
            return subs.contains(sub);
        }

        public static TreeSet<DatatypeElement> getAllSubtypes(DatatypeElement de) {
            TreeSet<DatatypeElement> subs = new TreeSet<DatatypeElement>();
            subs.add(de);
            DatatypeElement.getAllSubtypes(de, subs);
            return subs;
        }

        private static void getAllSubtypes(DatatypeElement de, TreeSet<DatatypeElement> sub) {
            if (de._subtypes == null) {
                return;
            }
            for (DatatypeElement sd : de._subtypes) {
                sub.add(sd);
                DatatypeElement.getAllSubtypes(sd, sub);
            }
        }

        public static boolean areDisjoint(DatatypeElement de1, DatatypeElement de2) {
            return !de1.getPrimitive().equals(de2.getPrimitive());
        }
    }
}

