/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.numeric;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDNonNegativeInteger
extends Datatype<BigInteger> {
    public static final Resource DT = XSD.NONNEGATIVEINTEGER;
    private BigInteger _bi;
    public static final String REGEX = "([+]?[0-9]*|[-]?[0]*)";

    public XSDNonNegativeInteger(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex ([+]?[0-9]*|[-]?[0]*).", s, DT, 20);
        }
        try {
            this._bi = !s.startsWith("+") ? new BigInteger(s) : new BigInteger(s.substring(1));
        }
        catch (NumberFormatException e) {
            throw new DatatypeParseException("Error parsing BigInteger: " + e.getMessage() + ".", s, DT, 21);
        }
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._bi.toString();
    }

    @Override
    public BigInteger getValue() {
        return this._bi;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDNonNegativeInteger dec = new XSDNonNegativeInteger("1234");
        System.err.println(dec.getCanonicalRepresentation());
    }
}

