/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Count<T>
extends HashMap<T, Integer> {
    private static final long serialVersionUID = -8495375842744348018L;
    long _total = 0L;

    public long getTotal() {
        return this._total;
    }

    public int add(T id, int value) {
        Integer i = (Integer)this.get(id);
        if (i == null) {
            i = 0;
        }
        i = i + value;
        this._total += (long)value;
        this.put(id, i);
        return i;
    }

    public int add(T id) {
        Integer i = (Integer)this.get(id);
        if (i == null) {
            i = 0;
        }
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        ++this._total;
        this.put(id, i);
        return i;
    }

    public void addAll(Map<T, Integer> all) {
        for (Map.Entry<T, Integer> pair : all.entrySet()) {
            if (pair.getKey() == null || pair.getValue() == null) continue;
            this.add(pair.getKey(), pair.getValue());
        }
    }

    public void printStats() {
        this.printStats(System.out);
    }

    public void printStats(PrintStream out) {
        for (Map.Entry e : this.entrySet()) {
            out.println(e.getKey() + "\t" + e.getValue());
        }
        out.flush();
    }

    public void printStats(Logger log, Level l) {
        for (Map.Entry e : this.entrySet()) {
            log.log(l, e.getKey() + "\t" + e.getValue());
        }
    }

    public void printOrderedStats() {
        this.printOrderedStats(Integer.MAX_VALUE, System.out);
    }

    public void printOrderedStats(PrintStream out) {
        this.printOrderedStats(Integer.MAX_VALUE, out);
    }

    public TreeSet<Map.Entry<T, Integer>> getKeyOrderedEntries() {
        Iterator it = this.entrySet().iterator();
        TreeSet<Map.Entry<T, Integer>> ts = new TreeSet<Map.Entry<T, Integer>>(new KeyComparator());
        while (it.hasNext()) {
            ts.add(it.next());
        }
        return ts;
    }

    public TreeSet<Map.Entry<T, Integer>> getOccurrenceOrderedEntries() {
        return this.getOccurrenceOrderedEntries(false);
    }

    public TreeSet<Map.Entry<T, Integer>> getOccurrenceOrderedEntries(boolean ascending) {
        Iterator it = this.entrySet().iterator();
        TreeSet<Map.Entry<T, Integer>> ts = new TreeSet<Map.Entry<T, Integer>>(new OccurrenceComparator(ascending));
        while (it.hasNext()) {
            ts.add(it.next());
        }
        return ts;
    }

    public void printOrderedStats(int topK) {
        this.printOrderedStats(topK, System.out);
    }

    public void printOrderedStats(int topK, PrintStream out) {
        Iterator<Map.Entry<T, Integer>> it = this.getOccurrenceOrderedEntries().iterator();
        for (int i = 0; it.hasNext() && i < topK; ++i) {
            Map.Entry<T, Integer> e = it.next();
            out.println(e.getKey() + "\t" + e.getValue());
        }
        out.flush();
    }

    public void printOrderedStats(Logger log, Level l) {
        this.printOrderedStats(Integer.MAX_VALUE, log, l);
    }

    public void printOrderedStats(int topK, Logger log, Level l) {
        Iterator<Map.Entry<T, Integer>> it = this.getOccurrenceOrderedEntries().iterator();
        for (int i = 0; it.hasNext() && i < topK; ++i) {
            Map.Entry<T, Integer> e = it.next();
            log.log(l, e.getKey() + "\t" + e.getValue());
        }
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        for (Map.Entry e : this.entrySet()) {
            s.append(e.getKey() + "\t" + e.getValue() + "\n");
        }
        return s.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this._total = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyComparator<T extends Comparable<? super T>>
    implements Comparator<Map.Entry<T, Integer>>,
    Serializable {
        private static final long serialVersionUID = -1229701058223158391L;

        @Override
        public int compare(Map.Entry<T, Integer> m1, Map.Entry<T, Integer> m2) {
            Comparable n2;
            Comparable n1 = (Comparable)m1.getKey();
            int diff = n1.compareTo(n2 = (Comparable)m2.getKey());
            if (diff != 0) {
                return diff;
            }
            int count1 = m1.getValue();
            int count2 = m2.getValue();
            return count2 - count1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OccurrenceComparator<T extends Comparable<? super T>>
    implements Comparator<Map.Entry<T, Integer>>,
    Serializable {
        private static final long serialVersionUID = -8794378599730605754L;
        boolean _ascending;

        public OccurrenceComparator() {
            this(false);
        }

        public OccurrenceComparator(boolean ascending) {
            this._ascending = ascending;
        }

        @Override
        public int compare(Map.Entry<T, Integer> m1, Map.Entry<T, Integer> m2) {
            int count1 = m1.getValue();
            int count2 = m2.getValue();
            int diff = this._ascending ? count1 - count2 : count2 - count1;
            if (diff != 0) {
                return diff;
            }
            Comparable n1 = (Comparable)m1.getKey();
            Comparable n2 = (Comparable)m2.getKey();
            return n1.compareTo(n2);
        }
    }
}

