/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.tld;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.yars.tld.TldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIHandler
implements Comparator<String> {
    private static final String NO_HOST = "no_host";
    private static final Runtime runtime = Runtime.getRuntime();
    private static final NumberFormat FMT = NumberFormat.getInstance();
    private static Set<String> noTLDSet;
    private static Set<String> tldSet;
    private static Set<String> wildcardTLDSet;
    private static TldManager _tldManager;

    public static void logMem(String msg) {
        long mem = runtime.maxMemory() - runtime.totalMemory();
        float KBytes = (float)mem / 1024.0f;
        float MBytes = KBytes / 1024.0f;
        float GBytes = MBytes / 1024.0f;
        if (GBytes >= 1.0f) {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(GBytes) + " GB");
        } else if (MBytes >= 1.0f) {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(MBytes) + " MB");
        } else {
            System.err.println("[MEMLOG] (" + msg + ") FreeMemory: " + FMT.format(KBytes) + " KB");
        }
    }

    private static void parseTLD() throws IOException {
        _tldManager = new TldManager();
    }

    public static String getPLD(String uri) {
        URI tmp = null;
        try {
            tmp = new URI(uri);
        }
        catch (Exception e) {
            System.err.println("[ERROR] malformed url " + e.getMessage());
            return NO_HOST;
        }
        return _tldManager.getPLD(tmp);
    }

    public static String getPLD(URI uri) {
        String pld = _tldManager.getPLD(uri);
        if (pld == null) {
            return NO_HOST;
        }
        return pld;
    }

    public static String[] getPathTokens(String uri) {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> tokens = new ArrayList();
        String path = "";
        try {
            URI tmp = new URI(uri.toString());
            path = tmp.getPath();
        }
        catch (URISyntaxException e) {
            try {
                URL url = new URL(uri.toString());
                path = url.getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (path == null) {
            path = "";
        }
        tokens = Arrays.asList(path.split("/"));
        for (String string : tokens) {
            String s = string.trim();
            if (s.length() == 0) continue;
            s = s.replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", "").replaceAll("\n", "\\\n");
            s = path.contains(string + "/") ? "/" + s + "/" : (s.contains(".") ? "/" + s.substring(0, s.lastIndexOf(".")) : "/" + s);
            if (result.contains(s)) continue;
            result.add(s);
        }
        if (path.endsWith("/") || path.trim().length() == 0) {
            // empty if block
        }
        String[] tmp = new String[result.size()];
        return result.toArray(tmp);
    }

    public static String[] getPathTokens(URI uri) {
        String[] tokens;
        ArrayList<String> result = new ArrayList<String>();
        String path = uri.getPath();
        if (path == null) {
            path = "";
        }
        for (String token : tokens = path.split("/")) {
            String s = token.trim();
            if (s.length() == 0) continue;
            s = s.replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", "").replaceAll("\n", "\\\n");
            s = path.contains(token + "/") ? "/" + s + "/" : (s.contains(".") ? "/" + s.substring(0, s.lastIndexOf(".")) : "/" + s);
            if (result.contains(s)) continue;
            result.add(s);
        }
        String[] tmp = new String[result.size()];
        return result.toArray(tmp);
    }

    public static String getFileName(String uri) {
        String path = "";
        try {
            URI tmp = new URI(uri.toString());
            path = tmp.getPath();
        }
        catch (URISyntaxException e) {
            try {
                URL url = new URL(uri.toString());
                path = url.getPath();
            }
            catch (MalformedURLException eURL) {
                // empty catch block
            }
        }
        if (path == null) {
            return "/NO_FNAME";
        }
        File file = new File(path);
        String fName = file.getName();
        if (fName.endsWith("/")) {
            return "/NO_FNAME";
        }
        if (fName.contains(".")) {
            fName = fName.substring(0, fName.lastIndexOf("."));
        }
        if ((fName = fName.replaceAll("\\{", "").replaceAll("\\}", "").replaceAll("\"", "").replaceAll(",", "").replaceAll(" ", "_").replaceAll("'", "").replaceAll("%", "")).trim().length() == 0) {
            return "/NO_FNAME";
        }
        return "/" + fName;
    }

    public static String getFileExtension(String uri) {
        String ext = "";
        String path = "";
        try {
            URI tmp = new URI(uri.toString());
            path = tmp.getPath();
        }
        catch (URISyntaxException e) {
            try {
                URL url = new URL(uri.toString());
                path = url.getPath();
            }
            catch (MalformedURLException eURL) {
                // empty catch block
            }
        }
        if (path == null) {
            return ".NOEXT";
        }
        File file = new File(path);
        if (file.getName().endsWith("/")) {
            return ".NOEXT";
        }
        int extIndex = file.getName().lastIndexOf(".");
        if (extIndex > -1) {
            ext = file.getName().substring(extIndex).trim();
        }
        if (ext.length() == 0 || ext.contains(",") || ext.contains("}") || ext.contains("/") || ext.contains("{") || ext.contains("=") || ext.contains("'") || ext.contains("(") || ext.contains(")") || ext.contains(" ")) {
            return ".NOEXT";
        }
        return ext.trim().toLowerCase();
    }

    public static String getFileExtension(URI uri) {
        String ext = "";
        String path = uri.getPath();
        if (path == null) {
            return ".NOEXT";
        }
        if (path.endsWith("/")) {
            return ".NOEXT";
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex > -1) {
            ext = path.substring(extIndex).trim();
        }
        if (ext.length() == 0 || ext.length() > 4) {
            return ".NOEXT";
        }
        return ext.trim().toLowerCase();
    }

    public static void main(String[] args) throws IOException {
        URIHandler handler = new URIHandler();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String line = "";
        while ((line = br.readLine()) != null) {
            System.out.println(URIHandler.getPLD(line.trim()));
        }
    }

    @Override
    public int compare(String o1, String o2) {
        System.out.println("compare(" + o1 + "," + o2 + ")");
        return o1.compareTo(o2);
    }

    public static long getFreeMem() {
        return runtime.maxMemory() - runtime.totalMemory();
    }

    public String getDomain(String uri) {
        URL url;
        try {
            URI tmp = new URI(uri.toString());
            url = tmp.toURL();
        }
        catch (Exception e) {
            try {
                url = new URL(uri.toString());
            }
            catch (MalformedURLException eURL) {
                System.err.println("[ERROR] malformed url " + eURL.getMessage());
                return "NO_HOST";
            }
        }
        return url.getHost();
    }

    static {
        FMT.setMaximumFractionDigits(2);
        FMT.setMinimumFractionDigits(2);
        noTLDSet = new HashSet<String>();
        tldSet = new HashSet<String>();
        wildcardTLDSet = new HashSet<String>();
        try {
            URIHandler.parseTLD();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

