/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.local;

import com.calpano.common.server.local.LocalBuildHelper;
import com.calpano.common.server.local.ShutdownServer;
import com.calpano.common.server.util.LocalLogConf;
import de.xam.files.FileChangeWatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.exception.MethodInvocationException;
import org.xydra.conf.IConfig;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.gwttools.GwtBuildHelper;
import org.xydra.jetty.Jetty;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.impl.log4j.Log4jLoggerFactory;
import org.xydra.log.spi.ILoggerFactorySPI;
import org.xydra.log.util.Log4jUtils;
import org.xydra.restless.Restless;

@RequireConf(value={"delegateUnhandledRequestsToDefaultServlet"})
public class LocalJettyServer {
    private static Jetty jetty;
    private static URI uri;
    private static List<FileChangeWatcher> fileChangeWatchers;
    private static final Logger log;

    public static void start() throws MethodInvocationException, IOException {
        boolean watchGwtModulesAndCopyAutomatically;
        boolean delegateUnhandledRequestsToDefaultServlet;
        System.out.println("--- Starting Local Jetty. Log system runs fine? ---");
        Log4jUtils.configureLog4j();
        LocalLogConf.configureLog4j();
        log.info("--- Log system runs fine! ---");
        LocalJettyServer.configureGeneralDefaults();
        if (!Env.get().conf().getBoolean("inProduction")) {
            LocalJettyServer.configureTestingDefaults();
        }
        IConfig conf = Env.get().conf();
        Restless.DELEGATE_UNHANDLED_TO_DEFAULT = delegateUnhandledRequestsToDefaultServlet = conf.getBoolean("delegateUnhandledRequestsToDefaultServlet");
        LocalBuildHelper.buildAll();
        boolean cssTemplateCompiler = conf.getBoolean("cssTemplateCompiler");
        if (cssTemplateCompiler) {
            FileChangeWatcher cssWatcher = FileChangeWatcher.startWatching((String)LocalBuildHelper.CSS_TEMPLATE_COMPILER.getTemplateDir(), (String)("." + LocalBuildHelper.CSS_TEMPLATE_COMPILER.getTemplateExt()), (Runnable)new Runnable(){

                @Override
                public void run() {
                    System.out.println("Server reloaded.");
                    jetty.stopServer();
                    LocalBuildHelper.CSS_TEMPLATE_COMPILER.run();
                    jetty.startServer();
                }
            });
            fileChangeWatchers.add(cssWatcher);
        }
        if (watchGwtModulesAndCopyAutomatically = conf.getBoolean("watchGwtModulesAndCopyAutomatically")) {
            log.info("Watching GWT modules and copy automatically");
            GwtBuildHelper gwtBuildHelper = new GwtBuildHelper(LocalBuildHelper.getTargetWebAppDir());
            FileChangeWatcher gwtWatcher = FileChangeWatcher.startWatching((String)LocalBuildHelper.getTargetWebAppDir(), null, (Runnable)gwtBuildHelper);
            fileChangeWatchers.add(gwtWatcher);
        }
        conf.set("jetty-port", (Object)8765);
        File webappDir = new File("src/main/webapp");
        conf.set("jetty-docroot", (Object)webappDir.getAbsolutePath());
        jetty = new Jetty();
        jetty.configureFromConf(conf);
        uri = jetty.startServer();
        log.info("Embedded Jetty runs at " + uri.toString() + " and serves " + webappDir.getAbsolutePath());
        log.info(".oO ___ Running ____________________________");
        ShutdownServer ss = new ShutdownServer(8766, null);
        ss.startListeningForStopRequests();
    }

    private static void configureGeneralDefaults() {
        IConfig conf = Env.get().conf();
        conf.setDefault("appArtifactId", (Object)"app", true);
        conf.setDefault("appMavenVersion", (Object)"0.0.1-SNAPSHOT", true);
        conf.setDefault("cssTemplateCompiler", (Object)false, true);
        conf.setDefault("gwtI18nBundleWriter", (Object)false, true);
    }

    private static void configureTestingDefaults() {
        if (Env.get().conf().getBoolean("inProduction")) {
            throw new RuntimeException("Won't run tests on AppEngine in production mode");
        }
        IConfig conf = Env.get().conf();
        conf.setBoolean("delegateUnhandledRequestsToDefaultServlet", true);
        conf.setLong("simulateWebDelayAjaxMs", 800L);
        conf.setLong("simulateWebDelayPageMs", 2000L);
    }

    public static URI getServerURI() {
        if (jetty == null) {
            try {
                return new URI("http://0.0.0.0:8765");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    public static void stop() {
        for (FileChangeWatcher fcw : fileChangeWatchers) {
            fcw.interrupt();
        }
        if (jetty != null) {
            jetty.stopServer();
        }
        log.info("Server stopped.");
    }

    public static void startShell() {
        try {
            LocalJettyServer.start();
            InputStreamReader isr = new InputStreamReader(System.in, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (!line.equals("q")) {
                System.out.println("Enter 'q' (enter) to stop server");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            LocalJettyServer.stop();
        }
    }

    static {
        fileChangeWatchers = new ArrayList<FileChangeWatcher>();
        LoggerFactory.setLoggerFactorySPI((ILoggerFactorySPI)new Log4jLoggerFactory(), (String)"LocalJettyServer");
        log = LoggerFactory.getLogger(LocalJettyServer.class);
    }
}

