/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.tagrules;

import java.util.LinkedHashSet;
import java.util.Set;

public class TagPattern {
    private static final String PLUSMINUS_REGEX = ",";
    private final Set<String> includes = new LinkedHashSet<String>();
    private final Set<String> excludes = new LinkedHashSet<String>();

    public static TagPattern compile(String tags) {
        TagPattern pattern = new TagPattern();
        String[] parts = tags.split(PLUSMINUS_REGEX);
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("-")) {
                pattern.excludes.add(parts[i].substring(1));
                continue;
            }
            pattern.includes.add(parts[i]);
        }
        return pattern;
    }

    public String toString() {
        return "include " + this.includes.size() + " exclude " + this.excludes.size();
    }

    public boolean includes(String tag) {
        return this.includes.contains(tag);
    }

    public boolean excludes(String tag) {
        return this.excludes.contains(tag);
    }

    public static void main(String[] args) {
        TagPattern tp = TagPattern.compile("this,-that,abc");
        TagPattern user = new TagPattern();
        user.addTag("this", true);
        assert (!user.matchesTagPattern(tp));
        user.addTag("abc", true);
        assert (user.matchesTagPattern(tp));
        System.out.println(tp);
    }

    public void addTag(String tag, boolean include) {
        if (include) {
            this.includes.add(tag);
        } else {
            this.excludes.add(tag);
        }
    }

    public boolean matchesTagPattern(TagPattern pattern) {
        for (String required : pattern.includes) {
            if (this.includes.contains(required)) continue;
            return false;
        }
        for (String forbidden : pattern.excludes) {
            if (!this.includes.contains(forbidden)) continue;
            return false;
        }
        return true;
    }

    public Set<String> getExcludedTags() {
        return this.excludes;
    }

    public Set<String> getIncludedTags() {
        return this.includes;
    }
}

