/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.server.util;

import com.calpano.common.server.p13n.P13nServletUtils;
import de.xam.p13n.shared.Personalisation;
import javax.servlet.http.HttpServletRequest;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.ServletUtils;

public class ServletTools {
    private static final Logger log = LoggerFactory.getLogger(ServletTools.class);

    public static String getClientId(HttpServletRequest req, String thirdLevel, String[] domainsDe, String[] domainsEn) {
        String host = req.getServerName();
        if (host == null || host.equals("") || host.equals("localhost") || host.equals("127.0.0.1")) {
            return "www";
        }
        String prefix = "";
        boolean languageByDomain = false;
        if (domainsDe != null) {
            for (String domainDe : domainsDe) {
                if (!host.endsWith(domainDe)) continue;
                prefix = host.substring(0, host.length() - domainDe.length());
                languageByDomain = true;
            }
        }
        if (!languageByDomain && domainsEn != null) {
            for (String domainEn : domainsEn) {
                if (!host.endsWith(domainEn)) continue;
                prefix = host.substring(0, host.length() - domainEn.length());
                languageByDomain = true;
            }
        }
        if (!languageByDomain) {
            throw new RuntimeException("We run on an unknown host: '" + host + "'");
        }
        if (prefix.equals("")) {
            return "www";
        }
        if (prefix.equals("www.")) {
            return "www";
        }
        assert (prefix.length() >= 2);
        int usesLength = thirdLevel.length();
        if (prefix.length() > usesLength) {
            String clientId = prefix.substring(0, prefix.length() - usesLength);
            return clientId;
        }
        log.warn("Could not extract clientId from prefix '" + prefix + "', return 'www'");
        return "www";
    }

    public static Personalisation getP13nFromServerName(HttpServletRequest req, String domainDe, String domainEn, Personalisation defaultP13n) {
        String locale = (String)ServletUtils.getRequestparametersAsMap((HttpServletRequest)req).get("locale");
        if (locale != null) {
            if (locale.equals("de")) {
                return Personalisation.GERMANY;
            }
            if (locale.equals("en")) {
                return Personalisation.EN_US__SAN_FRANCISCO;
            }
            log.warn("Did not understand locale override '" + locale + "', using default");
            return Personalisation.DEFAULT;
        }
        String serverName = req.getServerName();
        if (serverName.endsWith(domainDe)) {
            return Personalisation.GERMANY;
        }
        if (serverName.endsWith(domainEn)) {
            return Personalisation.EN_US__SAN_FRANCISCO;
        }
        log.warn("Servername could not be used for p13n: '" + serverName + "'");
        return defaultP13n;
    }

    public static String getServerNameFromP13n(Personalisation p13n, String domainDe, String domainEn, String defaultDomain) {
        if (p13n == null) {
            throw new IllegalArgumentException("p13n is null");
        }
        if (p13n.getLocale() == null || p13n.getLocale().getLanguage() == null) {
            throw new IllegalArgumentException("p13n imprecise, found no language " + p13n);
        }
        if (p13n.getLocale().getLanguage().equalsIgnoreCase("de")) {
            return domainDe;
        }
        if (p13n.getLocale().getLanguage().equalsIgnoreCase("en")) {
            return domainEn;
        }
        log.warn("No special domain for lang '" + p13n.getLocale() + "' using default");
        return defaultDomain;
    }

    public static Personalisation getP13nFromRequest(HttpServletRequest req, Personalisation defaultP13n, String domainDe, String domainEn) {
        String locale = (String)ServletUtils.getRequestparametersAsMap((HttpServletRequest)req).get("locale");
        if (locale != null) {
            if (locale.equals("de")) {
                return Personalisation.GERMANY;
            }
            if (locale.equals("en")) {
                return Personalisation.EN_US__SAN_FRANCISCO;
            }
            log.warn("Did not understand locale override '" + locale + "', using default");
            return Personalisation.DEFAULT;
        }
        if (req.getHeader("Accept-Language") == null) {
            return ServletTools.getP13nFromServerName(req, domainDe, domainEn, defaultP13n);
        }
        return P13nServletUtils.computePersonalisation(req, null, null, defaultP13n);
    }
}

