/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tokenpipe.sink;

import com.google.common.base.Joiner;
import de.xam.texthtml.text.TextTool;
import de.xam.tokenpipe.IToken;
import de.xam.tokenpipe.ITokenSink;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xydra.core.serialize.xml.XmlEncoder;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DefaultHtmlLayerParserSink
implements ITokenSink {
    public static final String[] EMPTY_TAGS = new String[]{"hr", "br", "link", "meta", "area", "base", "col", "command", "embed", "img", "input", "keygen", "param", "source", "track", "wbr"};
    public static Set<String> emptyTags = new HashSet<String>();
    public static final String[] FOLLOWED_BY_NEWLINE_TAGS = new String[]{"hr", "br", "li", "ul", "h1", "h2", "h3", "h4", "h5", "h6"};
    public static Set<String> followedByNewlineTags = new HashSet<String>();
    private static final Logger log = LoggerFactory.getLogger(DefaultHtmlLayerParserSink.class);
    private static final String NEWLINE = "\n";
    public static final String[] PRECEEDED_BY_NEWLINE_TAGS = new String[]{"hr", "li", "ul"};
    public static Set<String> preceededByNewlineTags = new HashSet<String>();
    private boolean generateHtml;
    private int indentDepth = 0;
    private StringBuilder resultHtml;
    private boolean startOfLine = true;
    private Object parseContext;

    @Override
    public String[] consumedTokenTypes() {
        throw new UnsupportedOperationException();
    }

    private void emptyTag(String tagName) {
        this.resultHtml.append("<" + tagName + "/>");
    }

    private void endTag(String tagName) {
        this.resultHtml.append("</" + tagName + ">");
    }

    @Override
    public String getLabel() {
        return "htmlsink";
    }

    public StringBuilder getResultHtmlFragment() {
        return this.resultHtml;
    }

    private void indent(String indent) {
        this.resultHtml.append(TextTool.indent((int)this.indentDepth, (String)indent));
    }

    private void newline() {
        this.resultHtml.append(NEWLINE);
        this.startOfLine = true;
    }

    @Override
    public void onAfterDocument() {
        log.debug("Done with HTML. Resulting HTML lenght = " + this.resultHtml.length());
    }

    @Override
    public void onBeforeDocument() {
        this.resultHtml = new StringBuilder();
    }

    @Override
    public void onException(Throwable e) {
        log.warn("Exception", e);
    }

    @Override
    public void onToken(IToken t) {
        if (!this.generateHtml) {
            return;
        }
        assert (this.resultHtml != null);
        String tagName = t.getType().toLowerCase();
        switch (t.getKind()) {
            case Start: {
                if (preceededByNewlineTags.contains(tagName)) {
                    if (!this.startOfLine) {
                        this.resultHtml.append(NEWLINE);
                    }
                    this.startOfLine = true;
                }
                if (this.startOfLine) {
                    this.indent("  ");
                }
                if (emptyTags.contains(t.getType().toLowerCase())) {
                    this.emptyTag(tagName);
                } else {
                    this.openTagStart(tagName);
                    HashSet<String> classNames = new HashSet<String>();
                    for (Map.Entry<String, String> entry : t.getContextAsMap().entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if (key.startsWith("data-")) {
                            this.openTagAttribute(tagName, key, value);
                            continue;
                        }
                        if (key.startsWith("class-")) {
                            assert (value != null) : "key=" + key;
                            classNames.add(value);
                            continue;
                        }
                        if (!key.startsWith("copy-")) continue;
                        assert (value != null) : "key=" + key;
                        this.openTagAttribute(tagName, key.substring("copy-".length()), value);
                    }
                    if (!classNames.isEmpty()) {
                        this.openTagAttribute(tagName, "class", Joiner.on((String)" ").join(classNames));
                    }
                    this.openTagEnd();
                }
                this.startOfLine = false;
                ++this.indentDepth;
                break;
            }
            case End: {
                --this.indentDepth;
                if (!emptyTags.contains(t.getType().toLowerCase())) {
                    if (this.startOfLine) {
                        this.indent("  ");
                    }
                    this.endTag(tagName);
                    this.startOfLine = false;
                }
                if (!followedByNewlineTags.contains(tagName)) break;
                this.newline();
                break;
            }
            case Content: {
                this.resultHtml.append(XmlEncoder.encode((String)t.getChars()));
                this.startOfLine = false;
            }
        }
    }

    private void openTagAttribute(String tagName, String key, String value) {
        this.resultHtml.append(" " + key + "=\"" + value + "\"");
    }

    private void openTagEnd() {
        this.resultHtml.append(">");
    }

    private void openTagStart(String tagName) {
        this.resultHtml.append("<" + tagName);
    }

    @Override
    public String[] producedTokenTypes() {
        return new String[0];
    }

    public void setGenerateHtml(boolean generateHtml) {
        this.generateHtml = generateHtml;
    }

    @Override
    public void setParseContext(Object parseContext) {
        this.parseContext = parseContext;
    }

    static {
        emptyTags.addAll(Arrays.asList(EMPTY_TAGS));
        followedByNewlineTags.addAll(Arrays.asList(FOLLOWED_BY_NEWLINE_TAGS));
        preceededByNewlineTags.addAll(Arrays.asList(PRECEEDED_BY_NEWLINE_TAGS));
    }
}

