/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.memcache.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.xgae.memcache.api.IMemCache;

public class LocalMemcache
implements IMemCache {
    private static final Logger log = LoggerFactory.getLogger(LocalMemcache.class);
    private static final byte[] NULL_VALUE = "null_value".getBytes();
    private static final long RESERVE_MEMORY = 0x500000L;
    private final ConcurrentHashMap<String, byte[]> internalMap;

    public int size() {
        return this.internalMap.size();
    }

    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(LocalMemcache.valueToStored(value));
    }

    public Object get(Object key) {
        byte[] bytes = this.internalMap.get(key);
        if (bytes == null) {
            return null;
        }
        Object result = LocalMemcache.storedToValue(bytes);
        return result;
    }

    public Object put(String key, Object value) {
        this.controlCacheSize();
        byte[] oldValue = this.internalMap.put(key, LocalMemcache.valueToStored(value));
        if (oldValue == null) {
            return null;
        }
        return LocalMemcache.storedToValue(oldValue);
    }

    private static final Object storedToValue(byte[] stored) {
        XyAssert.xyAssert((stored != null ? 1 : 0) != 0);
        assert (stored != null);
        if (stored == NULL_VALUE) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(stored);
            ObjectInputStream oin = new ObjectInputStream(bis);
            Object result = oin.readObject();
            oin.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static final byte[] valueToStored(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
            byte[] bytes = bos.toByteArray();
            return bytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void controlCacheSize() {
        long free = Runtime.getRuntime().freeMemory();
        if (free < 0x500000L) {
            log.warn("Free memory = " + free + ", require " + 0x500000L + " -> Auto-clear.");
            this.clear();
            System.gc();
        }
    }

    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.internalMap.clear();
    }

    public Set<String> keySet() {
        return this.internalMap.keySet();
    }

    public Collection<Object> values() {
        LinkedList<Object> result = new LinkedList<Object>();
        for (byte[] o : this.internalMap.values()) {
            result.add(LocalMemcache.storedToValue(o));
        }
        return result;
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, byte[]> e : this.internalMap.entrySet()) {
            result.put(e.getKey(), LocalMemcache.storedToValue(e.getValue()));
        }
        return result.entrySet();
    }

    public boolean equals(Object o) {
        return this.internalMap.equals(o);
    }

    public int hashCode() {
        return this.internalMap.hashCode();
    }

    public LocalMemcache() {
        log.info("Using LocalMemcache");
        this.internalMap = new ConcurrentHashMap();
    }

    public String stats() {
        return "In-memory, items: " + this.size();
    }

    public Map<String, Object> getAll(Collection<String> keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            Object value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public void putIfValueIsNull(String key, Object value) {
        this.internalMap.putIfAbsent(key, LocalMemcache.valueToStored(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putIfUntouched(String key, IMemCache.IdentifiableValue oldValue, Object newValue) {
        ConcurrentHashMap<String, byte[]> concurrentHashMap = this.internalMap;
        synchronized (concurrentHashMap) {
            Object current = this.get(key);
            if (oldValue.getValue() == null) {
                if (current == null) {
                    this.put(key, newValue);
                    return true;
                }
                return false;
            }
            if (current.equals(oldValue.getValue())) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    public IMemCache.IdentifiableValue getIdentifiable(String key) {
        Object o = this.get(key);
        return new IdentifiableImpl(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> incrementAll(Map<String, Long> offsets, long initialValue) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        ConcurrentHashMap<String, byte[]> concurrentHashMap = this.internalMap;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, Long> entry : offsets.entrySet()) {
                long newValue;
                String key = entry.getKey();
                byte[] valueBytes = this.internalMap.get(key);
                if (valueBytes == null) {
                    newValue = initialValue;
                } else {
                    Object value = LocalMemcache.storedToValue(valueBytes);
                    XyAssert.xyAssert((boolean)(value instanceof Long));
                    long oldValue = (Long)value;
                    newValue = oldValue + entry.getValue();
                }
                result.put(key, newValue);
                valueBytes = LocalMemcache.valueToStored(newValue);
                this.internalMap.put(key, valueBytes);
            }
        }
        return result;
    }

    public Object putChecked(String key, Object value) throws IOException {
        return this.put(key, value);
    }

    public static class IdentifiableImpl
    implements IMemCache.IdentifiableValue {
        private final Object o;

        public IdentifiableImpl(Object o) {
            this.o = o;
        }

        public Object getValue() {
            return this.o;
        }
    }
}

