/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.memcache.impl.gae;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.Stats;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.store.impl.utils.DebugFormatter;
import org.xydra.xgae.gaeutils.AboutAppEngine;
import org.xydra.xgae.memcache.api.IMemCache;
import org.xydra.xgae.util.XGaeDebugHelper;

public class GaeLowLevelMemCache
implements IMemCache {
    private static final Logger log = LoggerFactory.getLogger(GaeLowLevelMemCache.class);
    private static final String MEMCACHE_NAME = "[#=MC]";
    private final MemcacheService memcacheService = MemcacheServiceFactory.getMemcacheService();
    private final String appVersion = AboutAppEngine.getVersion();

    public String stats() {
        Stats stats = this.memcacheService.getStatistics();
        return "In-memory, size: " + this.size() + " maxTimeWithoutAccess: " + stats.getBytesReturnedForHits() + " hits: " + stats.getHitCount() + " misses: " + stats.getMissCount() + " TotalItemBytes: " + stats.getTotalItemBytes() + " BytesReturnedForHits: " + stats.getBytesReturnedForHits();
    }

    public int size() {
        return (int)this.memcacheService.getStatistics().getItemCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        assert (key instanceof String);
        String usedKey = key instanceof String ? (String)key : key.toString();
        return this.memcacheService.contains((Object)GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(usedKey));
    }

    private static String keyUniqueForCurrentAppVersion(String key) {
        return key;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("GaeMemcache does not support this");
    }

    public Object get(Object key) {
        assert (key instanceof String);
        String usedKey = key instanceof String ? (String)key : key.toString();
        Object o = this.memcacheService.get((Object)GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(usedKey));
        log.debug(XGaeDebugHelper.dataGet((String)MEMCACHE_NAME, (String)usedKey, (Object)o, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return o;
    }

    public Map<String, Object> getAll(Collection<String> keys) {
        Map result = this.memcacheService.getAll(keys);
        log.debug(XGaeDebugHelper.dataGet((String)MEMCACHE_NAME, keys, (Map)result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return result;
    }

    public Object put(String key, Object value) {
        XyAssert.xyAssert((value != null ? 1 : 0) != 0, (Object)"value is null");
        assert (value != null);
        log.debug(XGaeDebugHelper.dataPut((String)MEMCACHE_NAME, (String)key.toString(), (Object)value, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.memcacheService.put((Object)GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(key), value);
        return null;
    }

    public Object remove(Object key) {
        assert (key instanceof String);
        String usedKey = key instanceof String ? (String)key : key.toString();
        log.debug(XGaeDebugHelper.dataPut((String)MEMCACHE_NAME, (String)usedKey, null, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return this.memcacheService.delete((Object)GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(usedKey));
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m.isEmpty()) {
            return;
        }
        log.debug(XGaeDebugHelper.dataPut((String)MEMCACHE_NAME, m, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        HashMap<String, Object> keyTransformedMap = new HashMap<String, Object>();
        for (Map.Entry<? extends String, ? extends Object> mapEntry : m.entrySet()) {
            XyAssert.xyAssert((mapEntry.getValue() != null ? 1 : 0) != 0, (Object)"mapEntry.getValue() is null");
            assert (mapEntry.getValue() != null);
            keyTransformedMap.put(GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(mapEntry.getKey()), mapEntry.getValue());
        }
        this.memcacheService.putAll(keyTransformedMap);
    }

    public void clear() {
        log.debug(XGaeDebugHelper.clear((String)MEMCACHE_NAME));
        this.memcacheService.clearAll();
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException("GaeMemcache does not support this");
    }

    public Collection<Object> values() {
        throw new UnsupportedOperationException("GaeMemcache does not support this");
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException("GaeMemcache does not support this");
    }

    public void putIfValueIsNull(String key, Object value) {
        XyAssert.xyAssert((value != null ? 1 : 0) != 0, (Object)"value is null");
        assert (value != null);
        log.debug(XGaeDebugHelper.dataPutIfNull((String)MEMCACHE_NAME, (Object)key, (Object)value, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.memcacheService.put((Object)key, value, Expiration.byDeltaSeconds((int)864000), MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
        if (log.isTraceEnabled()) {
            log.debug("[#=MC] now " + DebugFormatter.format((Object)this.memcacheService.get((Object)key)));
        }
    }

    public IMemCache.IdentifiableValue getIdentifiable(String key) {
        MemcacheService.IdentifiableValue id = this.memcacheService.getIdentifiable((Object)GaeLowLevelMemCache.keyUniqueForCurrentAppVersion(key));
        log.debug(XGaeDebugHelper.dataGet((String)MEMCACHE_NAME, (String)key, (Object)id, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        return new IdentifiableValueImpl(id);
    }

    public boolean putIfUntouched(String key, IMemCache.IdentifiableValue oldValue, Object newValue) {
        boolean result;
        XyAssert.xyAssert((newValue != null ? 1 : 0) != 0, (Object)"newValue is null");
        assert (newValue != null);
        assert (oldValue instanceof IdentifiableValueImpl) : "this cache can only handly its own impls " + oldValue.getClass().getCanonicalName();
        IdentifiableValueImpl idImpl = (IdentifiableValueImpl)oldValue;
        MemcacheService.IdentifiableValue gaeId = idImpl.getAppEngineInternal();
        Expiration expiration = Expiration.byDeltaSeconds((int)864000);
        if (gaeId == null) {
            log.debug(XGaeDebugHelper.dataPutIfNull((String)MEMCACHE_NAME, (Object)key, (Object)newValue, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            result = this.memcacheService.put((Object)key, newValue, expiration, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
        } else {
            log.debug(XGaeDebugHelper.dataPutIfUntouched((String)MEMCACHE_NAME, (Object)key, (Object)oldValue, (Object)newValue, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
            result = this.memcacheService.putIfUntouched((Object)key, gaeId, newValue, expiration);
        }
        if (log.isTraceEnabled()) {
            log.debug("[#=MC] now " + DebugFormatter.format((Object)this.memcacheService.get((Object)key)));
        }
        return result;
    }

    public Map<String, Long> incrementAll(Map<String, Long> offsets, long initialValue) {
        return this.memcacheService.incrementAll(offsets, Long.valueOf(initialValue));
    }

    public Object putChecked(String key, Object value) throws IOException {
        try {
            return this.put(key, value);
        }
        catch (MemcacheServiceException e) {
            throw new IOException(e);
        }
    }

    private static class IdentifiableValueImpl
    implements IMemCache.IdentifiableValue {
        private final MemcacheService.IdentifiableValue id;

        public IdentifiableValueImpl(MemcacheService.IdentifiableValue id) {
            this.id = id;
        }

        public Object getValue() {
            return this.id == null ? null : this.id.getValue();
        }

        public MemcacheService.IdentifiableValue getAppEngineInternal() {
            return this.id;
        }
    }
}

