/*
 * Decompiled with CFR 0.152.
 */
package de.xam.devtools.serviceloader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class ServiceLoaderTool {
    public static void clearServiceLoaderDirectory(File mavenProjectRootDir) {
        File serviceDir = ServiceLoaderTool.ensureServiceDir(mavenProjectRootDir);
        for (File f : serviceDir.listFiles()) {
            f.delete();
        }
    }

    public static void writeServiceLoaderFile(File mavenProjectRootDir, Class<?> clazz, Class<?> interfaze, String comment) throws IOException {
        File serviceDir = ServiceLoaderTool.ensureServiceDir(mavenProjectRootDir);
        File f = new File(serviceDir, interfaze.getCanonicalName());
        ArrayList<String> lines = new ArrayList<String>();
        if (comment != null) {
            lines.add("# " + comment);
        }
        lines.add(clazz.getCanonicalName() + " # written by " + ServiceLoaderTool.class.getCanonicalName() + " on " + new Date());
        FileUtils.writeLines((File)f, lines);
        System.out.println("Written to " + f.getAbsolutePath());
    }

    private static File ensureServiceDir(File mavenProjectRootDir) {
        if (!mavenProjectRootDir.exists() || !mavenProjectRootDir.isDirectory()) {
            throw new IllegalArgumentException("Dir '" + mavenProjectRootDir.getAbsolutePath() + "' is not an existing directory");
        }
        File serviceDir = new File(mavenProjectRootDir, "/src/main/resources/META-INF/services");
        serviceDir.mkdirs();
        return serviceDir;
    }
}

