/*
 * Decompiled with CFR 0.152.
 */
package de.xam.kfacet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xydra.base.Base;
import org.xydra.base.XId;

public class ExternalProperty {
    private static final String regex = "([^.]+)[.]([^.]+)[.]([^.]+)";
    private static final Pattern p_parse = Pattern.compile("([^.]+)[.]([^.]+)[.]([^.]+)");
    XId itemId;
    XId propertyId;
    String extension;

    public String toString() {
        return "ExternalProperty [itemId=" + this.itemId + ", propertyId=" + this.propertyId + ", extension=" + this.extension + "]";
    }

    public static String getPropertyStorageFilename(XId sourceItemId, XId propertyId, String extension) {
        return sourceItemId + "." + propertyId + "." + extension;
    }

    public static ExternalProperty parsePropertyStorageFilename(String localName) {
        Matcher m = p_parse.matcher(localName);
        if (m.matches()) {
            ExternalProperty ep = new ExternalProperty();
            ep.itemId = Base.toId((String)m.group(1));
            ep.propertyId = Base.toId((String)m.group(2));
            ep.extension = m.group(3);
            return ep;
        }
        return null;
    }

    public static void main(String[] args) {
        XId i = Base.toId((String)"item");
        XId p = Base.toId((String)"property");
        String ext = "ext";
        String s = ExternalProperty.getPropertyStorageFilename(i, p, "ext");
        ExternalProperty ep = ExternalProperty.parsePropertyStorageFilename(s);
        System.out.println(ep);
    }
}

