/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.concurrent.GuardedBy;

public final class VmConfig {
    private final File javaHome;
    private final ImmutableList<String> options;
    @GuardedBy(value="this")
    private File javaExecutable;

    private VmConfig(Builder builder) {
        this.javaHome = builder.javaHome;
        this.options = builder.optionsBuilder.build();
    }

    @VisibleForTesting
    public VmConfig(File javaHome, Iterable<String> options, File javaExecutable) {
        this.javaHome = (File)Preconditions.checkNotNull((Object)javaHome);
        this.javaExecutable = (File)Preconditions.checkNotNull((Object)javaExecutable);
        this.options = ImmutableList.copyOf(options);
    }

    public File javaHome() {
        return this.javaHome;
    }

    public synchronized File javaExecutable() {
        if (this.javaExecutable == null) {
            File bin = new File(this.javaHome, "bin");
            Preconditions.checkState((bin.exists() && bin.isDirectory() ? 1 : 0) != 0, (String)"Could not find %s under java home %s", (Object[])new Object[]{bin, this.javaHome});
            File jvm = new File(bin, "java");
            if (!(jvm.exists() && !jvm.isDirectory() || (jvm = new File(bin, "java.exe")).exists() && !jvm.isDirectory())) {
                throw new IllegalStateException(String.format("Cannot find java binary in %s, looked for java and java.exe", bin));
            }
            this.javaExecutable = jvm;
        }
        return this.javaExecutable;
    }

    public ImmutableList<String> options() {
        return this.options;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VmConfig) {
            VmConfig that = (VmConfig)obj;
            return this.javaHome.equals(that.javaHome) && this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.javaHome, this.options});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("javaHome", (Object)this.javaHome).add("options", this.options).toString();
    }

    @VisibleForTesting
    public static final class Builder {
        private final File javaHome;
        private final ImmutableList.Builder<String> optionsBuilder = ImmutableList.builder();

        public Builder(File javaHome) {
            this.javaHome = (File)Preconditions.checkNotNull((Object)javaHome);
        }

        public Builder addOption(String option) {
            this.optionsBuilder.add((Object)option);
            return this;
        }

        public Builder addAllOptions(Iterable<String> options) {
            this.optionsBuilder.addAll(options);
            return this;
        }

        public VmConfig build() {
            return new VmConfig(this);
        }
    }
}

