/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.model.Trial;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.Experiment;
import com.google.caliper.runner.ExperimentModule;
import com.google.caliper.runner.ExperimentSelector;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.TrialFailureException;
import com.google.caliper.runner.TrialRunLoop;
import com.google.caliper.runner.TrialScopes;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.runner.VirtualMachine;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.CreationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Provider;

@VisibleForTesting
public final class ExperimentingCaliperRun
implements CaliperRun {
    private static final Logger logger = Logger.getLogger(ExperimentingCaliperRun.class.getName());
    private final Injector injector;
    private final CaliperOptions options;
    private final PrintWriter stdout;
    private final PrintWriter stderr;
    private final BenchmarkClass benchmarkClass;
    private final ImmutableSet<Instrument> instruments;
    private final ImmutableSet<ResultProcessor> resultProcessors;
    private final ExperimentSelector selector;
    private final Provider<TrialRunLoop> runLoopProvider;
    private volatile int trialNumber = 1;

    @Inject
    @VisibleForTesting
    public ExperimentingCaliperRun(Injector injector, CaliperOptions options, @Stdout PrintWriter stdout, @Stderr PrintWriter stderr, BenchmarkClass benchmarkClass, ImmutableSet<Instrument> instruments, ImmutableSet<ResultProcessor> resultProcessors, ExperimentSelector selector, Provider<TrialRunLoop> runLoopProvider) {
        this.injector = injector;
        this.options = options;
        this.stdout = stdout;
        this.stderr = stderr;
        this.benchmarkClass = benchmarkClass;
        this.instruments = instruments;
        this.resultProcessors = resultProcessors;
        this.runLoopProvider = runLoopProvider;
        this.selector = selector;
    }

    @Override
    public void run() throws InvalidBenchmarkException {
        this.stdout.println("Experiment selection: ");
        this.stdout.println("  Instruments:   " + FluentIterable.from(this.selector.instruments()).transform((Function)new Function<Instrument, String>(){

            public String apply(Instrument instrument) {
                return instrument.name();
            }
        }));
        this.stdout.println("  User parameters:   " + this.selector.userParameters());
        this.stdout.println("  Virtual machines:  " + FluentIterable.from(this.selector.vms()).transform((Function)new Function<VirtualMachine, String>(){

            public String apply(VirtualMachine vm) {
                return vm.name;
            }
        }));
        this.stdout.println("  Selection type:    " + this.selector.selectionType());
        this.stdout.println();
        ImmutableSet<Experiment> allExperiments = this.selector.selectExperiments();
        if (allExperiments.isEmpty()) {
            throw new InvalidBenchmarkException("There were no experiments to be performed for the class %s using the instruments %s", this.benchmarkClass.benchmarkClass().getSimpleName(), this.instruments);
        }
        this.stdout.format("This selection yields %s experiments.%n", allExperiments.size());
        this.stdout.flush();
        ImmutableSet<Experiment> experimentsToRun = this.dryRun((Iterable<Experiment>)allExperiments);
        if (experimentsToRun.size() != allExperiments.size()) {
            this.stdout.format("%d experiments were skipped.%n", allExperiments.size() - experimentsToRun.size());
        }
        if (experimentsToRun.isEmpty()) {
            throw new InvalidBenchmarkException("All experiments were skipped.", new Object[0]);
        }
        if (this.options.dryRun()) {
            return;
        }
        this.stdout.flush();
        int totalTrials = experimentsToRun.size() * this.options.trialsPerScenario();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int i = 0; i < this.options.trialsPerScenario(); ++i) {
            for (Experiment experiment : experimentsToRun) {
                this.stdout.printf("Starting trial %d of %d: %s\u2026 ", this.trialNumber, totalTrials, experiment);
                try {
                    Trial trial = TrialScopes.makeContext(UUID.randomUUID(), this.trialNumber, experiment).call(new Callable<Trial>(){

                        @Override
                        public Trial call() throws Exception {
                            return ((TrialRunLoop)ExperimentingCaliperRun.this.runLoopProvider.get()).call();
                        }
                    });
                    this.stdout.println("Complete!");
                    for (ResultProcessor resultProcessor : this.resultProcessors) {
                        resultProcessor.processTrial(trial);
                    }
                }
                catch (TrialFailureException e) {
                    this.stderr.println("ERROR: Trial failed to complete (its results will not be included in the run):\n  " + e.getMessage());
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    ++this.trialNumber;
                }
            }
        }
        this.stdout.print("\n");
        this.stdout.format("Execution complete: %s.%n", ShortDuration.of(stopwatch.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS));
        for (ResultProcessor resultProcessor : this.resultProcessors) {
            try {
                resultProcessor.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close a result processor: " + resultProcessor, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableSet<Experiment> dryRun(Iterable<Experiment> experiments) throws InvalidBenchmarkException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Experiment experiment : experiments) {
            Class<?> clazz = this.benchmarkClass.benchmarkClass();
            try {
                Object benchmark = this.injector.createChildInjector(new Module[]{ExperimentModule.forExperiment(experiment)}).getInstance(Key.get(clazz));
                this.benchmarkClass.setUpBenchmark(benchmark);
                try {
                    experiment.instrumentation().dryRun(benchmark);
                    builder.add((Object)experiment);
                }
                finally {
                    this.benchmarkClass.cleanup(benchmark);
                }
            }
            catch (ProvisionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw new UserCodeException(cause);
                }
                throw e;
            }
            catch (CreationException e) {
                StringBuilder message = new StringBuilder("Could not create an instance of the benchmark class following reasons:");
                int errorNum = 0;
                for (Message guiceMessage : e.getErrorMessages()) {
                    message.append("\n  ").append(++errorNum).append(") ").append(guiceMessage.getMessage());
                }
                throw new InvalidBenchmarkException(message.toString(), new Object[]{e});
            }
            catch (SkipThisScenarioException innocuous) {
            }
        }
        return builder.build();
    }
}

