/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class JarFinder {
    private static final Logger logger = Logger.getLogger(JarFinder.class.getName());
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on((char)' ').omitEmptyStrings();

    JarFinder() {
    }

    public static ImmutableSet<File> findJarFiles(ClassLoader first, ClassLoader ... rest) throws IOException {
        Scanner scanner = new Scanner();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (ClassLoader classLoader : Lists.asList((Object)first, (Object[])rest)) {
            map.putAll(JarFinder.getClassPathEntries(classLoader));
        }
        for (Map.Entry entry : map.entrySet()) {
            scanner.scan((URI)entry.getKey(), (ClassLoader)entry.getValue());
        }
        return scanner.jarFiles();
    }

    @VisibleForTesting
    static ImmutableMap<URI, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(JarFinder.getClassPathEntries(parent));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry : urlClassLoader.getURLs()) {
                URI uri;
                try {
                    uri = entry.toURI();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                if (entries.containsKey(uri)) continue;
                entries.put(uri, classloader);
            }
        }
        return ImmutableMap.copyOf((Map)entries);
    }

    @VisibleForTesting
    static final class Scanner {
        private final ImmutableSet.Builder<File> jarFiles = new ImmutableSet.Builder();
        private final Set<URI> scannedUris = Sets.newHashSet();

        Scanner() {
        }

        ImmutableSet<File> jarFiles() {
            return this.jarFiles.build();
        }

        void scan(URI uri, ClassLoader classloader) throws IOException {
            if (uri.getScheme().equals("file") && this.scannedUris.add(uri)) {
                this.scanFrom(new File(uri), classloader);
            }
        }

        @VisibleForTesting
        void scanFrom(File file, ClassLoader classloader) throws IOException {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(file, classloader);
            } else {
                this.scanJar(file, classloader);
            }
        }

        private void scanDirectory(File directory, ClassLoader classloader) {
            this.scanDirectory(directory, classloader, "");
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix) {
            for (File file : directory.listFiles()) {
                String name = file.getName();
                if (!file.isDirectory()) continue;
                this.scanDirectory(file, classloader, packagePrefix + name + "/");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            this.jarFiles.add((Object)file);
            try {
                for (URI uri : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(uri, classloader);
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }

        @VisibleForTesting
        static ImmutableSet<URI> getClassPathFromManifest(File jarFile, @Nullable Manifest manifest) {
            if (manifest == null) {
                return ImmutableSet.of();
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (classpathAttribute != null) {
                for (String path : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)classpathAttribute)) {
                    URI uri;
                    try {
                        uri = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (URISyntaxException e) {
                        logger.warning("Invalid Class-Path entry: " + path);
                        continue;
                    }
                    builder.add((Object)uri);
                }
            }
            return builder.build();
        }

        @VisibleForTesting
        static URI getClassPathEntry(File jarFile, String path) throws URISyntaxException {
            URI uri = new URI(path);
            return uri.isAbsolute() ? uri : new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI();
        }
    }
}

