/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.model.ArbitraryMeasurement;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.runner.Running;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerOptions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Map;

public final class ArbitraryMeasurementWorker
extends Worker {
    private final Options options;
    private final String unit;
    private final String description;

    @Inject
    ArbitraryMeasurementWorker(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, @WorkerOptions Map<String, String> workerOptions) {
        super(benchmark, method);
        this.options = new Options(workerOptions);
        ArbitraryMeasurement annotation = method.getAnnotation(ArbitraryMeasurement.class);
        this.unit = annotation.units();
        this.description = annotation.description();
    }

    @Override
    public void preMeasure() throws Exception {
        if (this.options.gcBeforeEach) {
            Util.forceGc();
        }
    }

    @Override
    public Iterable<Measurement> measure() throws Exception {
        double measured = (Double)this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        return ImmutableSet.of((Object)new Measurement.Builder().value(Value.create(measured, this.unit)).weight(1.0).description(this.description).build());
    }

    private static class Options {
        final boolean gcBeforeEach;

        Options(Map<String, String> options) {
            this.gcBeforeEach = Boolean.parseBoolean(options.get("gcBeforeEach"));
        }
    }
}

