/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.BridgeModule;
import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.json.GsonModule;
import com.google.caliper.runner.BenchmarkClassModule;
import com.google.caliper.runner.ExperimentModule;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.caliper.worker.WorkerModule;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;

public final class WorkerMain {
    private WorkerMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Injector gsonInjector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new GsonModule()});
        WorkerSpec request = (WorkerSpec)((Gson)gsonInjector.getInstance(Gson.class)).fromJson(args[0], WorkerSpec.class);
        Injector workerInjector = gsonInjector.createChildInjector(new Module[]{new BenchmarkClassModule(Class.forName(request.benchmarkSpec.className())), ExperimentModule.forWorkerSpec(request), new BridgeModule(), new WorkerModule(request)});
        Worker worker = (Worker)workerInjector.getInstance(Worker.class);
        WorkerEventLog log = (WorkerEventLog)workerInjector.getInstance(WorkerEventLog.class);
        log.notifyWorkerStarted(request.trialId);
        try {
            worker.setUpBenchmark();
            log.notifyWarmupPhaseStarting();
            worker.bootstrap();
            log.notifyMeasurementPhaseStarting();
            boolean keepMeasuring = true;
            while (keepMeasuring) {
                worker.preMeasure();
                log.notifyMeasurementStarting();
                try {
                    keepMeasuring = log.notifyMeasurementEnding(worker.measure());
                }
                finally {
                    worker.postMeasure();
                }
            }
        }
        catch (Exception e) {
            log.notifyFailure(e);
        }
        finally {
            System.out.flush();
            worker.tearDownBenchmark();
        }
    }
}

