package com.calpano.common.client.crashreport;

import org.xydra.env.IEnvironment;
import org.xydra.log.api.Logger;
import org.xydra.log.api.Logger.Level;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.util.SharedExceptionUtils;
import org.xydra.log.util.listener.RememberLogListener;

import com.calpano.common.client.ConfParamsCalpanoCommonClient;
import com.google.gwt.core.client.GWT;
import com.google.web.bindery.event.shared.UmbrellaException;

public class ClientExceptionHandler implements GWT.UncaughtExceptionHandler {

	private final Logger log;

	private final IEnvironment env;

	/**
	 * Remembers most logs to be sent along when an error occurs.
	 */
	public static RememberLogListener rememberLogListener = null;

	/**
	 * @param env
	 *            @NeverNull
	 * @param log
	 *            the logger of a class that is known to run OK
	 * @param rememberLogs
	 */
	public ClientExceptionHandler(final IEnvironment env, final Logger log, final boolean rememberLogs) {
		this.env = env;
		this.log = log;

		if (rememberLogs) {
			// create and attach log listener, skip everything at Trace level
			rememberLogListener = new RememberLogListener(Level.Debug);
			LoggerFactory.addLogListener(rememberLogListener);
		}
	}

	@Override
	public void onUncaughtException(final Throwable throwable) {
		final String text = "JS exception in Favr: \n" + SharedExceptionUtils.toString(throwable);
		this.log.error(text, throwable);
		// get UmbrellaException contents also
		if (throwable instanceof UmbrellaException) {
			final UmbrellaException ue = (UmbrellaException) throwable;
			for (final Throwable cause : ue.getCauses()) {
				if (cause.equals(throwable)) {
					this.log.info("Nested in Umbrella: Same exception as already reported.");
				} else {
					this.log.error("Additional exception in umbrella: " + cause.getMessage(), cause);
				}
			}
		}

		// local logging is nice, but we want it also on the server
		if (this.env.conf().getBoolean(ConfParamsCalpanoCommonClient.ClientDebugMode)) {
			com.google.gwt.user.client.Window.alert("JS error: "
					+ text.substring(0, Math.min(text.length(), 800)) + " \nCause: " + throwable);
		}
		ClientErrorHandlingUtils.handleError(this.env, text, "unknown", null,
				rememberLogListener == null ? null : rememberLogListener.getLogs());
	}

}
